package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.domain.convert.ck.InvCkDConvert;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCkD;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCkDDO;
import com.elitesland.yst.production.inv.domain.service.InvCkdDomainService;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDDTO;
import com.elitesland.yst.production.inv.infr.repo.ck.InvCkDRepo;
import com.elitesland.yst.production.inv.infr.repo.ck.InvCkDRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.querydsl.core.types.ExpressionUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/14
 * @Version 1.0
 * @Content:
 */
@Service
@AllArgsConstructor
public class InvCkdDomainServiceImpl implements InvCkdDomainService {
    private final InvCkDRepo invCkDRepo;
    private final InvCkDRepoProc invCkDRepoProc;

    /**
     * 库存盘点明细保存
     *
     * @param invCkD
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveInvCkD(InvCkD invCkD) {
        InvCkDDO invCkDDO = InvCkDConvert.INSTANCE.enToDo(invCkD);
        return invCkDRepo.save(invCkDDO).getId();
    }

    /**
     * 库存盘点明细批量保存
     *
     * @param invCkDList
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<Long> saveInvCkDList(List<InvCkD> invCkDList) {
        List<InvCkDDO> invCkDDOList = invCkDList.stream().map(InvCkDConvert.INSTANCE::enToDo).collect(Collectors.toList());
        return invCkDRepo.saveAll(invCkDDOList).stream().map(InvCkDDO::getId).collect(Collectors.toList());
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long id) {
        invCkDRepo.deleteByMasId(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasIdBatch(List<Long> idList) {
        idList.forEach(invCkDRepo::deleteByMasId);
    }

    @Override
    @SysCodeProc
    public List<InvCkDDTO> selectByMasId(Long masId) {
        List<InvCkDDTO> invCkDDTOList = invCkDRepoProc.selectByMasId(masId);
        if (CollectionUtils.isEmpty(invCkDDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return invCkDDTOList;
    }

    @Override
    public List<InvCkDDTO> selectByDeter2KeyWords(String deter2KeyWords) {
        if(!StringUtils.hasText(deter2KeyWords)){
            throw new BusinessException(ApiCode.FAIL,"参数校验不通过");
        }
        return invCkDRepoProc.selectByDeter2KeyWords(deter2KeyWords);
    }


}
