package com.elitesland.yst.production.inv.domain.service.impl;


import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocParamVO;
import com.elitesland.yst.production.inv.domain.convert.InvIocConvert;
import com.elitesland.yst.production.inv.domain.entity.ioc.InvIoc;
import com.elitesland.yst.production.inv.domain.entity.ioc.InvIocDO;
import com.elitesland.yst.production.inv.domain.service.InvIocDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvIocDTO;
import com.elitesland.yst.production.inv.infr.repo.ioc.InvIocRepo;
import com.elitesland.yst.production.inv.infr.repo.ioc.InvIocRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:库存操作码
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@Service("InvIocDomainService")
@AllArgsConstructor
public class InvIocDomainServiceImpl implements InvIocDomainService {

    private final InvIocRepo InvIocRepo;
    private final InvIocRepoProc InvIocRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<InvIocDTO> search(InvIocParamVO param) {
        val pagingVo = InvIocRepoProc.search(param);
        return pagingVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveInvIoc(InvIoc InvIoc, Optional<InvIocDTO> optional) {
        if (optional.isPresent()) {
            InvIocDTO InvIocDTO = optional.get();
            //修改时，不可编辑
            InvIoc.setIoCode(InvIocDTO.getIoCode());
            //修改
            InvIoc.setId(InvIocDTO.getId());
            InvIoc.setCreator(InvIocDTO.getCreator());
            InvIoc.setCreateUserId(InvIocDTO.getCreateUserId());
            InvIoc.setCreateTime(InvIocDTO.getCreateTime());
            InvIoc.setModifyTime(LocalDateTime.now());

        } else {
            InvIoc.setId(null);
            InvIoc.setCreator(null);
            InvIoc.setCreateUserId(null);
            InvIoc.setCreateTime(LocalDateTime.now());
            InvIoc.setModifyUserId(null);
            InvIoc.setUpdater(null);
            InvIoc.setModifyTime(LocalDateTime.now());
        }

        InvIocDO InvIocDO = InvIocConvert.INSTANCE.enToDo(InvIoc);
        Long id = InvIocRepo.save(InvIocDO).getId();

        return id;
    }

    /**
     * 根据ID查询库存操作码信息
     *
     * @param id 库存操作码ID
     * @return 库存操作码对象
     */
    @Override
    @SysCodeProc
    public Optional<InvIocDTO> findById(Long id) {
        return InvIocRepo.findById(id).map(InvIocConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public Optional<InvIocDTO> findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Optional.empty();
        }
        InvIocParamVO param = new InvIocParamVO();
        param.setIoCode(code);
        JPAQuery<InvIocDTO> jpaQuery = InvIocRepoProc.select(param);

        return Optional.of(jpaQuery.fetchFirst());
    }

    @Override
    @SysCodeProc
    public List<InvIocDTO> findByIdBatch(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvIocDTO> whAreaSettingDTOList = InvIocRepo.findAllById(idList).stream().map(InvIocConvert.INSTANCE::doToDto).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(whAreaSettingDTOList)) {
            return Collections.EMPTY_LIST;
        }

        return whAreaSettingDTOList;
    }

    @Override
    @SysCodeProc
    public List<InvIocDTO> findByCodeBatch(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.EMPTY_LIST;
        }
        InvIocParamVO param = new InvIocParamVO();
        param.setIoCodeList(codeList);
        JPAQuery<InvIocDTO> jpaQuery = InvIocRepoProc.select(param);
        List<InvIocDTO> InvIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty(InvIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return InvIocDTOS;
    }

    @Override
    @SysCodeProc
    public List<InvIocDTO> selectByParam(InvIocParamVO param) {
        JPAQuery<InvIocDTO> jpaQuery = InvIocRepoProc.select(param);
        List<InvIocDTO> InvIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty(InvIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return InvIocDTOS;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        InvIocRepoProc.updateDeleteFlagByIds(deleteFlag, idList).execute();
    }

}
