package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigQueryVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.param.InvSceneConfigQueryParam;
import com.elitesland.yst.production.inv.domain.convert.scene.InvSceneConfigConvert;
import com.elitesland.yst.production.inv.domain.entity.scene.InvSceneConfigDO;
import com.elitesland.yst.production.inv.domain.service.InvSceneConfigDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDTO;
import com.elitesland.yst.production.inv.infr.repo.scene.InvSceneConfigRepo;
import com.elitesland.yst.production.inv.infr.repo.scene.InvSceneConfigRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.AllArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/20 17:23
 */
@Service
@AllArgsConstructor
@Transactional
public class InvSceneConfigDomainServiceImpl implements InvSceneConfigDomainService {

    private final InvSceneConfigRepo invSceneConfigRepo;

    private final InvSceneConfigRepoProc invSceneConfigRepoProc;

    @Override
    @SysCodeProc
    public Optional<InvSceneConfigDO> findById(Long id) {
        if (StringUtils.isEmpty(id)) {
            return Optional.empty();
        }
        return invSceneConfigRepo.findById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteById(Long id) {
        invSceneConfigRepo.deleteById(id);
    }

    @Override
    public void updateDynamically(InvSceneConfigDO invSceneConfigDO) {
        invSceneConfigRepoProc.updateDynamically(invSceneConfigDO);
    }

    @Override
    public PagingVO<InvSceneConfigPageVO> searchPage(InvSceneConfigQueryParam param) {
        return invSceneConfigRepoProc.searchPage(param);
    }

    @Override
    public List<InvSceneConfigQueryVO> findSceneConfiBySceneCode(String sceneCode) {
        List<InvSceneConfigDO> sceneConfigDOS = invSceneConfigRepo.findAllBySceneCodeIs(sceneCode);
        return sceneConfigDOS.stream().map(InvSceneConfigConvert.INSTANCE::do2VO)
                .collect(Collectors.toList());
    }

    @Override
    public InvSceneConfigDTO findBySceneCode(String sceneCode) {
        List<InvSceneConfigDO> sceneConfigDOS = invSceneConfigRepo.findAllBySceneCodeIs(sceneCode);
        if(!CollectionUtils.isEmpty(sceneConfigDOS)){
            return InvSceneConfigConvert.INSTANCE.do2DTO(sceneConfigDOS.get(0));
        } else{
            return null;
        }
    }

}
