package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhPTypeRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invwh.*;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Service("InvWhDomainService")
@AllArgsConstructor
@Slf4j
public class InvWhDomainServiceImpl implements InvWhDomainService {

    private final InvWhRepo invWhRepo;

    private final InvWhRepoProc invWhRepoProc;

    @Override
    @SysCodeProc
    public Optional<InvWhRespVO> findIdOne(Long id) {
        JPAQuery<InvWhRespVO> jpaQuery = invWhRepoProc.select(null);
        val jpaQDo = QInvWhDO.invWhDO;
        jpaQuery.where(jpaQDo.id.eq(id));
        InvWhRespVO vo = jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> findByCodes(List<String> codes) {
        val jpaQDo = QInvWhDO.invWhDO;
        List<InvWhRespVO> whRespVOList = invWhRepoProc.select(null).where(jpaQDo.whCode.in(codes)).fetch();
        return whRespVOList;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> findIdBatch(List<Long> ids) {
        List<Long> idList = ids.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        val jpaQDo = QInvWhDO.invWhDO;
        List<InvWhRespVO> invWhRespVOS = invWhRepoProc.select(null).where(jpaQDo.id.in(idList)).fetch();
        return invWhRespVOS;
    }

    @Override
    @SysCodeProc
    public Optional<InvWhDO> findById(Long id) {
        return invWhRepo.findById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvWhDO saveInvWh(InvWhDO invWhDO) {
        return invWhRepo.save(invWhDO);
    }

    @Override
    @SysCodeProc
    public Optional<InvWhRespVO> findById(long id) {
        JPAQuery<InvWhRespVO> jpaQuery = invWhRepoProc.select(null);
        val jpaQDo = QInvWhDO.invWhDO;
        jpaQuery.where(jpaQDo.id.eq(id));
        InvWhRespVO vo = jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> invWhRepo.deleteById(id));
    }

    @Override
    @SysCodeProc
    public PagingVO<InvWhRespVO> searchWh(InvWhParamVO param) {
        JPAQuery<InvWhRespVO> invWhs = invWhRepoProc.select(null).where(invWhRepoProc.searchWhere(param));
        long dataCount = invWhs.fetchCount();
        List<InvWhRespVO> lists = invWhs.fetch();
        invWhRepoProc.openOrderAndLimit(invWhs, param, QInvWhDO.invWhDO);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(dataCount);
        return paging;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> searchWhByParam(InvWhParamVO param) {
        JPAQuery<InvWhRespVO> jpaQuery = invWhRepoProc.select(null).where(invWhRepoProc.searchWhere(param));
        List<InvWhRespVO> respVOS = jpaQuery.fetch();
        return respVOS;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> findByWhIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<InvWhRespVO> whRespVOS = invWhRepoProc.selectWhByWhIds(ids);
        return whRespVOS;
    }

    @Override
    @SysCodeProc
    public InvWhRespVO findByWhId(Long id) {
        return invWhRepoProc.selectWhByWhId(id);
    }

    @Override
    @SysCodeProc
    public List<InvWhRpcDTO> findWhRpcDTOByIdBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<InvWhRpcDTO> results = invWhRepoProc.findWhRpcDTOByIdBatch(ids);

        return results;
    }

    @Override
    @SysCodeProc
    public List<InvWhDetailRpcDTO> findWhRpcDTOByParam(InvWhRpcDtoParam param) {
        List<InvWhDetailRpcDTO> rpcDTOS = invWhRepoProc.findWhRpcDTOByParam(param);
        return rpcDTOS;
    }

    @Override
    @SysCodeProc
    public List<InvWhRpcDTO> findWhPartRpcDTOByParam(InvWhRpcDtoParam param) {
        List<InvWhRpcDTO> results = invWhRepoProc.findWhPartRpcDTOByParam(param);
        return results;
    }

    @Override
    @SysCodeProc
    public List<InvWhDeliveryRpcDTO> findWhRpcDTOByDelivery(InvWhDeliveryRpcDtoParam param) {
        List<InvWhDeliveryRpcDTO> whRpcDTOByDelivery = invWhRepoProc.findWhRpcDTOByDelivery(param);
        return whRpcDTOByDelivery;
    }

    @Override
    @SysCodeProc
    public List<InvWhDeliveryRpcDTO> findWhRpcDTOByAllArea(InvWhDeliveryRpcDtoParam param) {
        List<InvWhDeliveryRpcDTO> byAllArea = invWhRepoProc.findWhRpcDTOByAllArea(param);
        return byAllArea;
    }

    @Override
    @SysCodeProc
    public List<InvWhPTypeRespVO> findWhPTypeList(String pType) {
        List<InvWhPTypeRespVO> whPTypeList = invWhRepoProc.findWhPTypeList(pType);
        return whPTypeList;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> select(InvWhParamVO param) {
        JPAQuery<InvWhRespVO> jpaQuery = invWhRepoProc.select(param);
        return jpaQuery.fetch();
    }

    @Override
    public Boolean enableWhhConfig(Long id, String whStatus) {
        try {
            invWhRepoProc.enableWhhConfig(id, whStatus);
        } catch (Exception e){
            log.error("修改失败："+e.getMessage());
            return false;
        }
        return true;
    }
    @Override
    @SysCodeProc
    public Optional<InvWhDO>  findWhDOByWhId(Long id) {
        Optional<InvWhDO> optional = invWhRepo.findById(id);
        return optional;
    }




}
