package com.elitesland.yst.production.inv.infr.dto;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 品项
 * </p>
 *
 * @author niuchen
 * @date 2020/6/29
 */
@Data
@Accessors(chain = false)
@ApiModel(value = "ItmItemVO", description = "品项")
public class ItmItemDTO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 1729391895274562938L;


    @ApiModelProperty("客户商品编码")
    String custItmCode;

    @ApiModelProperty("税收分类码 [UDC]ITM:TAX_TYPE")
    @SysCode(sys = "ITM", mod = "TAX_TYPE")
    String taxType;
    String taxTypeName;

    @ApiModelProperty("包装方式 [UDC]ITM:PACKAGE_METHOD")
    @SysCode(sys = "ITM", mod = "PACKAGE_METHOD")
    String packageMethod;
    String packageMethodName;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long buId;

    @ApiModelProperty("品项编号")
    String itemCode;

    @ApiModelProperty("第二编号")
    String itemCode2;

    @ApiModelProperty("第三编号")
    String itemCode3;

    @ApiModelProperty("品项名称")
    String itemName;

    @ApiModelProperty("第二名称")
    String itemName2;

    @ApiModelProperty("第三名称")
    String itemName3;

    @ApiModelProperty("品项类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "ITM", mod = "ITEM_TYPE")
    String itemType;
    String itemTypeName;

    @ApiModelProperty("品项类型2 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "ITM", mod = "ITEM_TYPE2")
    String itemType2;
    String itemType2Name;

    @ApiModelProperty("品项类型3 [UDC]ITM:ITEM_TYPE3")
    @SysCode(sys = "ITM", mod = "ITEM_TYPE3")
    String itemType3;
    String itemType3Name;

    @ApiModelProperty("品项类型4 [UDC]INV:TRANSPORT_TEMP")
    @SysCode(sys = "yst-inv", mod = "TRANSPORT_TEMP")
    String itemType4;
    String itemType4Name;

    @ApiModelProperty("品项类型5")
    String itemType5;

    @ApiModelProperty("品项组 [UDC]ITM:ITEM_GROUP")
    @SysCode(sys = "ITM", mod = "ITEM_GROUP")
    String itemGroup;
    String itemGroupName;

    @ApiModelProperty("品项简称")
    String itemAbbr;

    @ApiModelProperty("品项标题 简短介绍")
    String itemTitle;

    @ApiModelProperty("品项描述 文描，可含有格式，包含导航段落信息")
    String itemDesc;

    @ApiModelProperty("副标题 如京东有")
    String subTitle;

    @ApiModelProperty("助记码")
    String memCode;

    @ApiModelProperty("条码")
    String barCode;

    @ApiModelProperty("条码2")
    String barCode2;

    @ApiModelProperty("拼音")
    String pinyin;

    @ApiModelProperty("拼音简称")
    String pinyinSh;

    @ApiModelProperty("促销信息")
    String promotionInfo;

    @ApiModelProperty("关键词")
    String keywords;

    @ApiModelProperty("标记 如热销、推荐、正品、新品。可多选")
    String marks;

    @ApiModelProperty("品项状态")
    @SysCode(sys = "ITM", mod = "ITEM_STATUS")
    String itemStatus;
    String itemStatusName;

    @ApiModelProperty("品项状态2")
    @SysCode(sys = "ITM", mod = "ITEM_STATUS")
    String itemStatus2;
    String itemStatus2Name;

    @ApiModelProperty("品项状态3")
    @SysCode(sys = "ITM", mod = "ITEM_STATUS")
    String itemStatus3;
    String itemStatus3Name;

    @ApiModelProperty("上架状态")
    String listingStatus;

    @ApiModelProperty("大类编号 使用COM_C1表")
    String c1Code;

//    @ApiModelProperty("品类")
//    ComC1VO c1CodeVO;

    @ApiModelProperty("中类编号 使用COM_C2表")
    String c2Code;

//    @ApiModelProperty("子品类")
//    ComC2VO c2CodeVO;

    @ApiModelProperty("小类编号")
    String c3Code;

    @ApiModelProperty("主计量单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("计量单位2")
    @SysCode(sys = "COM", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("计量单位3")
    @SysCode(sys = "COM", mod = "UOM")
    private String uom3;
    private String uom3Name;

    @ApiModelProperty("计量单位4")
    @SysCode(sys = "COM", mod = "UOM")
    private String uom4;
    private String uom4Name;

    @ApiModelProperty("计量单位5")
    @SysCode(sys = "COM", mod = "UOM")
    private String uom5;
    private String uom5Name;

    @ApiModelProperty("默认销售单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    @ApiModelProperty("默认采购单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    @ApiModelProperty("要货计量单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String orderUom;
    private String orderUomName;

    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    @ApiModelProperty("毛重")
    Float grossWeight;

    @ApiModelProperty("净重")
    Float netWeight;

    @ApiModelProperty("重量单位 克还是吨")
    @SysCode(sys = "COM", mod = "UOM")
    private String weightUom;
    private String weightUomName;

    @ApiModelProperty("重量对应的品项单位 支还是千支")
    @SysCode(sys = "COM", mod = "UOM")
    private String weightItemuom;
    private String weightItemuomName;

    @ApiModelProperty("毛重2")
    Float grossWeight2;

    @ApiModelProperty("净重2")
    Float netWeight2;

    @ApiModelProperty("重量2单位 克还是吨")
    @SysCode(sys = "COM", mod = "UOM")
    private String weightUom2;
    private String weightUom2Name;

    @ApiModelProperty("重量2对应的品项单位 箱或包等包装单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String weightItemuom2;
    private String weightItemuom2Name;

    @ApiModelProperty("体积")
    Float volume;

    @ApiModelProperty("最小起订量")
    Float moq;

    @ApiModelProperty("安全库存")
    Float safeQty;

    @ApiModelProperty("最大库存量")
    Float maxQty;

    @ApiModelProperty("最大要货量")
    Float maxOrderQty;

    @ApiModelProperty("存储类型")
//    @SysCode(sys = "ITM", mod = "STORE_MODE")
            String packageType;
//    String packageTypeName;

    @ApiModelProperty("整包装数量")
    Float packageQty;

    @ApiModelProperty("批量")
    Float batchQty;

    @ApiModelProperty("要货容差率")
    Float orderTolerance;

    @ApiModelProperty("默认售价")
    Float salePrice;

    @ApiModelProperty("销售价格组")
    String salePriceGroup;

    @ApiModelProperty("默认采购价")
    Float purcPrice;

    @ApiModelProperty("采购价格组")
    String purcPriceGroup;

    @ApiModelProperty("价格")
    Float itemPrice;

    @ApiModelProperty("调价周期")
    String pricePeriod;

    @ApiModelProperty("档口ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long stallId;

    @ApiModelProperty("档口编号")
    String stallCode;

    @ApiModelProperty("包装规格")
    String packageSpec;

    @ApiModelProperty("规格")
    String spec;

    @ApiModelProperty("材质")
    String material;

    @ApiModelProperty("等级")
    String grade;

    @ApiModelProperty("标准")
    String standard;

    @ApiModelProperty("表面处理")
    String surface;

    @ApiModelProperty("产地")
    String origin;

    @ApiModelProperty("印记")
    String stamp;

    @ApiModelProperty("长度")
    String itemLen;

    @ApiModelProperty("直径")
    String dimension;

    @ApiModelProperty("强度")
    String strength;

    @ApiModelProperty("牙别")
    String teeth;

    @ApiModelProperty("税码 进项VAT")
    String taxCode;

    @ApiModelProperty("税率索引 进项")
    @SysCode(sys = "COM", mod = "TAX_RATE_INDEX")
    String taxRateIndex;
    String taxRateIndexName;

    @ApiModelProperty("税率编号 进项VAT")
    String taxRateNo;

//    @ApiModelProperty("税率 进项VAT")
//    ComTaxRateVO comTaxRateNoVO;

    @ApiModelProperty("税率 进项VAT")
    Float taxRate;

    @ApiModelProperty("税码 销项VAT")
    String taxCodeOut;

    @ApiModelProperty("税率编号 销项VAT")
    String taxRateNoout;

//    @ApiModelProperty("税率 销项VAT")
//    ComTaxRateVO comTaxRateNooutVO;

    @ApiModelProperty("税率 销项VAT")
    Float taxRateOut;

    @ApiModelProperty("税率索引 销项")
    @SysCode(sys = "COM", mod = "TAX_RATE_INDEX")
    String taxRateIndexout;
    String taxRateIndexoutName;

    @ApiModelProperty("关税税率")
    Float taxRateTariff;

    @ApiModelProperty("采购员ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long purchaserId;

    @ApiModelProperty("销售员ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long salesmanId;

    @ApiModelProperty("采购员姓名")
    String purchaserName;

    @ApiModelProperty("销售员姓名")
    String salesmanName;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long suppId;

    @ApiModelProperty("供应商名称")
    String suppName;

    @ApiModelProperty("品牌")
    String brand;

    @ApiModelProperty("品牌名称")
    String brandName;

    @ApiModelProperty("品牌2")
    String brand2;

    @ApiModelProperty("品牌2名称")
    String brand2Name;

    @ApiModelProperty("代理商")
    String agency;

//    @ApiModelProperty("代理商信息")
//    ComC1VO agencyVO;

    @ApiModelProperty("要求部门ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long reqDeptId;

    @ApiModelProperty("要求原因")
    String reqReason;

    @ApiModelProperty("用途描述")
    String usageDesc;

    @ApiModelProperty("转正日期")
    LocalDateTime approveDate;

    @ApiModelProperty("财务总账类别 [UDC]ITM:FIN_GL_TYPE")
    @SysCode(sys = "ITM", mod = "FIN_GL_TYPE")
    String finGlType;
    String finGlTypeName;

    @ApiModelProperty("成本计价方式 FIFO/加权平均")
    String costType;

    @ApiModelProperty("成本级 [UDC]ITM:COST_LEVEL")
    @SysCode(sys = "ITM", mod = "COST_LEVEL")
    String costLeve;
    String costLeveName;

    @ApiModelProperty("采购类型 按计划采购/日常请购")
    String purchaseType;

    @ApiModelProperty("采购类型2 集采/地产")
    String purchaseType2;

    @ApiModelProperty("配货类型 总部强配/门店要货")
    String allocType;

    @ApiModelProperty("配送类型 总部配送/供应商配送")
    String deliverType;

    @ApiModelProperty("订货周期")
    String orderPeriod;

    @ApiModelProperty("库存ABC类型")
    String abcType;

    @ApiModelProperty("库存出库方式 FIFO/LIFO/批内FIFO/批内FILO")
    String storeOutMethod;

    @ApiModelProperty("库存管理类型 [UDC]ITM:STORE_TYPE")
    @SysCode(sys = "ITM", mod = "STORE_TYPE")
    String storeType;
    String storeTypeName;

    @ApiModelProperty("存储方式 [UDC]ITM:STORE_MODE")
    @SysCode(sys = "ITM", mod = "STORE_MODE")
    String storeMode;
    String storeModeName;

    @ApiModelProperty("保质期管理类型")
    String storeExpireType;

    @ApiModelProperty("保质期天数")
    @JsonSerialize(using = ToStringSerializer.class)
    Integer storeExpireDays;

    @ApiModelProperty("存储条件")
    String storeCondition;

    @ApiModelProperty("温层")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    String tempType;
    String tempTypeName;

    @ApiModelProperty("发运类型")
    String shipmentType;

    @ApiModelProperty("供应商回扣类型")
    String rebateType;

    @ApiModelProperty("计划类型")
    String planType;

    @ApiModelProperty("盘点类型 30天/60天")
    String takeType;

    @ApiModelProperty("仓库属性")
    String whProp;

    @ApiModelProperty("半成品存储仓位")
    String semiStore;

    @ApiModelProperty("转换率")
    Float repItemRate;

    @ApiModelProperty("默认启用批次")
    Boolean lotFlag;

    @ApiModelProperty("默认启用货位")
    Boolean locFlag;

    @ApiModelProperty("默认启用序列号")
    Boolean snFlag;

    @ApiModelProperty("原产国")
    @SysCode(sys = "COM", mod = "COUNTRY")
    String menuCountry;
    String menuCountryName;

    @ApiModelProperty("制造类型 成品/半成品/原料/物料")
    String manuType;

    @ApiModelProperty("制造商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long manuerId;

    @ApiModelProperty("制造商名称")
    String manuerName;

    @ApiModelProperty("供应商物料编码")
    String suppItemCode;

    @ApiModelProperty("标准成本")
    Float stdCost;

    @ApiModelProperty("标准人工")
    Float stdLabCost;

    @ApiModelProperty("标准制费")
    Float stdProdCost;

    @ApiModelProperty("替代属性 1：标准原料；2：替代原料")
    String replaceProp;

    @ApiModelProperty("替代原料ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long replaceItemId;

    @ApiModelProperty("其它类型1")
    String otherType1;

    @ApiModelProperty("其它类型2")
    String otherType2;

    @ApiModelProperty("其它类型3")
    String otherType3;

    @ApiModelProperty("其它类型4")
    String otherType4;

    @ApiModelProperty("其它类型5")
    String otherType5;

    @ApiModelProperty("外部编码")
    String outerCode;

    @ApiModelProperty("接口状态")
    String intfStatus;

    @ApiModelProperty("接口处理时间")
    LocalDateTime intfTime;

    @ApiModelProperty("标签")
    String tags;

    @ApiModelProperty("ES1")
    String es1;

    @ApiModelProperty("ES2")
    String es2;

    @ApiModelProperty("ES3")
    String es3;

    @ApiModelProperty("ES4")
    String es4;

    @ApiModelProperty("ES5")
    String es5;

    @ApiModelProperty("ES6")
    String es6;

    @ApiModelProperty("ES7")
    String es7;

    @ApiModelProperty("ES8")
    String es8;

    @ApiModelProperty("ES9")
    String es9;

    @ApiModelProperty("ES10")
    String es10;

    @ApiModelProperty("ES11")
    String es11;

    @ApiModelProperty("ES12")
    String es12;

    @ApiModelProperty("ES13")
    String es13;

    @ApiModelProperty("ES14")
    String es14;

    @ApiModelProperty("ES15")
    String es15;

    @ApiModelProperty("ES16")
    String es16;

    @ApiModelProperty("ES17")
    String es17;

    @ApiModelProperty("ES18")
    String es18;

    @ApiModelProperty("ES19")
    String es19;

    @ApiModelProperty("ES20")
    String es20;

    @ApiModelProperty("EN1")
    Float en1;

    @ApiModelProperty("EN2")
    Float en2;

    @ApiModelProperty("EN3")
    Float en3;

    @ApiModelProperty("EN4")
    Float en4;

    @ApiModelProperty("EN5")
    Float en5;

    @ApiModelProperty("ED1")
    LocalDateTime ed1;

    @ApiModelProperty("ED2")
    LocalDateTime ed2;

    @ApiModelProperty("ED3")
    LocalDateTime ed3;

    @ApiModelProperty
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @ApiModelProperty("申请人公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouCode;

    @ApiModelProperty("申请人公司")
    private String ouName2;

    @ApiModelProperty("申请部门编码")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buCode;

    @ApiModelProperty("申请部门")
    private String buName;

    /**
     * 添加人 ： 马世豪
     * VO增加品项的包装集合以及计量单位转换集合
     */
//    @ApiModelProperty("品项包装集合")
//    private List<ItmItemPkgVO> itmItemPkgVOS;
//
//    @ApiModelProperty("品项计量单位转换集合")
//    private List<ItmItemuomConvVO> itmItemuomConvVOS;

    /**
     * 预测锁定期
     */
    @ApiModelProperty("预测锁定期天数")
    private Integer fcstLockDays;
    /**
     * 预测锁定期
     */
    @ApiModelProperty("预测锁定期月份")
    private Integer fcstLockMonths;

    @ApiModelProperty("转换系数")
    @JsonSerialize(using = ToStringSerializer.class)
    private Double ratio;

    @ApiModelProperty("商品SKU品类编号")
    private String itemCateCode;

    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    // ------------ end ------------

}
