package com.elitesland.yst.production.inv.infr.repo;

import com.elitesland.yst.production.inv.application.facade.vo.InvIoSearchBatchParam;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvIoStkAcctRespVO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvIoDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

//import static com.elitesland.inv.entity.QInvStkDO.invStkDO;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author ssy
 * @since 2020-08-18 09:34:58
 */
@Component
@AllArgsConstructor
public class InvIoRepoProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;

    public JPAQuery<InvIoStkAcctRespVO> searchStkAcct(InvIoSearchBatchParam param) {
        val invIoDO = QInvIoDO.invIoDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvIoStkAcctRespVO> jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvIoStkAcctRespVO.class,
                        invIoDO.docNo,
                        invIoDO.id,
                        invIoDO.lotNo,
                        invIoDO.itemId,
                        invIoDO.whId,
                        invWhDO.whName,
                        invWhDO.whCode,
                        invIoDO.stkId,
                        invIoDO.deter1,
                        invIoDO.deter2,
                        invWhAreaDO.deter2Type,
                        invWhAreaDO.deter2Name,
                        invIoDO.deter3,
                        invIoDO.itemCateCode,
                        invIoDO.brand,
                        invIoDO.itemCode,
                        invIoDO.qty,
                        invIoDO.uom,
                        invIoDO.snNo,
                        invIoDO.limit1,
                        invIoDO.limit2,
                        invIoDO.limit3,
                        invIoDO.ioDate,
                        invIoDO.ioCode,
                        invIoDO.reasonCode,
                        invIoDO.srcDocCls,
                        invIoDO.srcDocNo,
                        invIoDO.srcDocNo2,
                        invIoDO.sceneCode,
                        invIoDO.ouId,
                        invIoDO.pType.as("PType"),
                        invIoDO.pCode.as("PCode"),
                        invIoDO.createTime,
                        invIoDO.creator,
                        invIoDO.createUserId,
                        invIoDO.modifyTime,
                        invIoDO.updater,
                        invIoDO.modifyUserId
                )
        ).from(invIoDO)
                .leftJoin(invWhDO).on(invIoDO.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaDO).on(invIoDO.deter2.eq(invWhAreaDO.deter2))
                .where(where(param), invIoDO.deleteFlag.eq(0).or(invIoDO.deleteFlag.isNull()));
        jpaQuery.groupBy(invIoDO.id);
        return jpaQuery;

    }

    Predicate where(InvIoSearchBatchParam param) {
        val invIoDO = QInvIoDO.invIoDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        /**数据权限*/
        try {
            Predicate predicateAuth = DataAuthJpaUtil.dataAuthJpaPredicate(invIoDO.getMetadata());
            predicate = ExpressionUtils.and(predicate, predicateAuth);
        } catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "数据权限异常");
        }
        if(StringUtils.hasLength(param.getDeter2KeyWord())){
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    invWhAreaDO.deter2.like("%" + param.getDeter2KeyWord() + "%"),
                    invWhAreaDO.deter2Name.like("%" + param.getDeter2KeyWord() + "%")
            ));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.whId.in(param.getWhIds()));
        }
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.docNo.eq(param.getDocNo()));
        }
        if (StringUtils.hasLength(param.getDeter2Type())) {
            predicate = ExpressionUtils.and(predicate, invWhAreaDO.deter2Type.eq(param.getDeter2Type()));
        }
        if (StringUtils.hasLength(param.getDeter2KeyWord())) {
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    invWhAreaDO.deter2.like("%" + param.getDeter2KeyWord() + "%"),
                    invWhAreaDO.deter2Name.like("%" + param.getDeter2KeyWord() + "%")
            ));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.deter1.eq(param.getDeter1()));
        }
        if (!StringUtils.isEmpty(param.getCreateUserId())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.createUserId.eq(param.getCreateUserId()));
        }
        if (!CollectionUtils.isEmpty(param.getDeter2s())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.deter2.in(param.getDeter2s()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocNo())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.srcDocNo.in(param.getSrcDocNo()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocNo2())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.srcDocNo2.in(param.getSrcDocNo2()));
        }
        if (!CollectionUtils.isEmpty(param.getItemIds())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.itemId.in(param.getItemIds()));
        }
        if (!CollectionUtils.isEmpty(param.getLotNos())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.lotNo.in(param.getLotNos()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.lotNo.like('%' + param.getLotNo() + '%'));
        }
        if (!StringUtils.isEmpty(param.getIoCode())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.ioCode.eq(param.getIoCode()));
        }
        if (!CollectionUtils.isEmpty(param.getIoCodes())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.ioCode.in(param.getIoCodes()));
        }
        if (!StringUtils.isEmpty(param.getIoDate())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.ioDate.between(LocalDateTime.of(param.getIoDate().toLocalDate(), LocalTime.MIN), LocalDateTime.of(param.getIoDate().toLocalDate(), LocalTime.of(23, 59, 59))));
        }
        if (!CollectionUtils.isEmpty(param.getOuIds())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.ouId.in(param.getOuIds()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocCls())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.srcDocCls.eq(param.getSrcDocCls()));
        }
        if (!StringUtils.isEmpty(param.getSrcDocNo())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.srcDocNo.like("%" + param.getSrcDocNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getNoStk())) {
            if (param.getNoStk().equals(true)) {
                predicate = ExpressionUtils.and(predicate, invIoDO.qty.ne(BigDecimal.ZERO));
            }
        }
        if (!CollectionUtils.isEmpty(param.getSrcDocClsList())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.srcDocCls.in(param.getSrcDocClsList()));
        }
        if (!StringUtils.isEmpty(param.getCreateUserId())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.createUserId.eq(param.getCreateUserId()));
        }
        if (!StringUtils.isEmpty(param.getPtype())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.pType.eq(param.getPtype()));
        }
        if (!Objects.isNull(param.getPcode())) {
            if (!StringUtils.isEmpty(param.getPcode().getPcode())) {
                predicate = ExpressionUtils.and(predicate, invIoDO.pCode.eq(param.getPcode().getPcode()));
            }
        }
        if (!CollectionUtils.isEmpty(param.getCreateTime())) {
            List<String> createTime = param.getCreateTime();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            predicate = ExpressionUtils.and(predicate,
                    invIoDO.createTime.after(LocalDate.parse(createTime.get(0), dateTimeFormatter).atStartOfDay()).and(
                            invIoDO.createTime.before(LocalDate.parse(createTime.get(1), dateTimeFormatter).atStartOfDay())));
        }

        if (!StringUtils.isEmpty(param.getCreateTimeFrom())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.createTime.after(param.getCreateTimeFrom()).or(invIoDO.createTime.eq(param.getCreateTimeFrom())));
        }
        if (!StringUtils.isEmpty(param.getCreateTimeTo())) {
            predicate = ExpressionUtils.and(predicate, invIoDO.createTime.before(param.getCreateTimeTo()).or(invIoDO.createTime.eq(param.getCreateTimeTo())));
        }
        return predicate;
    }
}
