package com.elitesland.yst.production.inv.infr.repo.ck;


import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkAndCkDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkDParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkDRespVO;
import com.elitesland.yst.production.inv.domain.entity.ck.QInvCkDDO;
import com.elitesland.yst.production.inv.domain.entity.ck.QInvCkDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lvqf
 * @date 2021-02-10
 */
@Component
@AllArgsConstructor
public class InvCkDRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    public Predicate where(InvCkDParamVO param) {
        val jpaQDo = QInvCkDDO.invCkDDO;
        Predicate predicate = jpaQDo.isNotNull();
        if (param.getMasId() != null) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.masId.eq(param.getMasId()));
        }
        return predicate;
    }

    public Predicate whereH(InvCkDParamVO param) {
        val jpaQDO = QInvCkDO.invCkDO;
        val jpaQDDO = QInvCkDDO.invCkDDO;
        Predicate predicate = jpaQDO.isNotNull().or(jpaQDDO.isNotNull());
        if (param.getMasId() != null) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.masId.eq(param.getMasId()));
        }
        /*if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docNo.eq(param.getDocNo()));
        }
        if (!StringUtils.isEmpty(param.getWhIds()) && param.getWhIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.whId.in(param.getWhIds()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.deter1.eq(param.getDeter1()));
        }
        if (!StringUtils.isEmpty(param.getDeter2s()) && param.getDeter2s().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.deter2.in(param.getDeter2s()));
        }
        if (!StringUtils.isEmpty(param.getDocDates()) && param.getDocDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docDate.between(param.getDocDates().get(0), param.getDocDates().get(1)));
        }
        //brands
        if (!StringUtils.isEmpty(param.getItemIds()) && param.getItemIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.itemId.in(param.getItemIds()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.lotNo.like("%" + param.getLotNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getDocStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docStatus.eq(param.getDocStatus()));
        }
        if (!StringUtils.isEmpty(param.getDocMethod())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docMethod.eq(param.getDocMethod()));
        }
        if (!StringUtils.isEmpty(param.getDocType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docType.eq(param.getDocType()));
        }
        if (!StringUtils.isEmpty(param.getDocMode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docMode.eq(param.getDocMode()));
        }*/


        return predicate;
    }

    public Predicate where(Long masId) {
        val jpaQDo = QInvCkDDO.invCkDDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNotNull());
        predicate = ExpressionUtils.and(predicate, jpaQDo.masId.eq(masId));
        return predicate;
    }

    public JPAQuery<InvCkAndCkDRespVO> selectH(InvCkDParamVO param) {
        val invCkDO = QInvCkDO.invCkDO;
        val invCkDDO = QInvCkDDO.invCkDDO;

        return jpaQueryFactory.select(
                Projections.bean(
                        InvCkAndCkDRespVO.class,
                        invCkDDO.id,
                        invCkDDO.masId,
                        invCkDDO.lotNo,
                        invCkDDO.pCode.as("PCode"),
                        invCkDDO.pType.as("pType"),
                        invCkDDO.uom,
                        invCkDDO.deter1,
                        invCkDDO.deter2,
                        invCkDDO.itemId,
                        invCkDO.docNo,
                        invCkDO.docMethod,
                        invCkDO.docMode,
                        invCkDO.docType,
                        invCkDO.docStatus,
                        invCkDO.whId,
                        invCkDO.ouId,
                        invCkDO.docCls

                        )
        ).from(invCkDDO)
                .leftJoin(invCkDO).on(invCkDDO.masId.eq(invCkDO.id))
                .where(whereH(param));
    }

    public List<InvCkDDTO> selectByDeter2KeyWords(String deter2KeyWords){
        val invCkDDO = QInvCkDDO.invCkDDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvCkDDTO.class,
                        invCkDDO.id,
                        invCkDDO.masId,
                        invCkDDO.whId,
                        invCkDDO.deter2,
                        invWhAreaDO.deter2Name,
                        invCkDDO.itemId,
                        invCkDDO.variId,
                        invCkDDO.lotNo,
                        invCkDDO.pCode.as("PCode"),
                        invCkDDO.pType.as("PType"),
                        invCkDDO.pCode,
                        invCkDDO.snNo,
                        invCkDDO.accQty,
                        invCkDDO.factQty,
                        invCkDDO.diffQty,
                        invCkDDO.uom,
                        invCkDDO.remark,
                        invCkDDO.createUserId,
                        invCkDDO.creator,
                        invCkDDO.secBuId,
                        invCkDDO.secUserId,
                        invCkDDO.secOuId
        )).from(invCkDDO).leftJoin(invWhAreaDO).on(invCkDDO.deter2.eq(invWhAreaDO.deter2)
                .and(invCkDDO.whId.eq(invWhAreaDO.whId)));
        Predicate predicate = invCkDDO.deleteFlag.eq(0).or(invCkDDO.deleteFlag.isNull());
        Predicate predicate2 = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    invWhAreaDO.deter2.like("%" + deter2KeyWords + "%"),
                    invWhAreaDO.deter2Name.like("%" + deter2KeyWords + "%")
            ));
        jpaQuery.where(predicate2);
        return jpaQuery.fetch();
    }

    public List<InvCkDDTO> selectByMasId(Long masId) {
        val invCkDDO = QInvCkDDO.invCkDDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvCkDDTO.class,
                        invCkDDO.id,
                        invCkDDO.masId,
                        invCkDDO.whId,
                        invCkDDO.deter2,
                        invCkDDO.itemId,
                        invCkDDO.variId,
                        invCkDDO.lotNo,
                        invCkDDO.pCode.as("PCode"),
                        invCkDDO.pType.as("PType"),
                        invCkDDO.pCode,
                        invCkDDO.snNo,
                        invCkDDO.accQty,
                        invCkDDO.factQty,
                        invCkDDO.diffQty,
                        invCkDDO.uom,
                        invCkDDO.remark,
                        invCkDDO.createUserId,
                        invCkDDO.creator,
                        invCkDDO.secBuId,
                        invCkDDO.secUserId,
                        invCkDDO.secOuId
                )
        ).from(invCkDDO).where(where(masId), invCkDDO.deleteFlag.eq(0).or(invCkDDO.deleteFlag.isNull()));
        return jpaQuery.fetch();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateFactQtyById(Long id,BigDecimal factQty){
        val invCkDDO = QInvCkDDO.invCkDDO;
        jpaQueryFactory.update(invCkDDO).set(invCkDDO.factQty, factQty).where(invCkDDO.id.eq(id)).execute();
    }
}
