package com.elitesland.yst.production.inv.infr.repo.invwh;

import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.domain.entity.whAreaSetting.QInvWhAreaSettingDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;

@Component
@AllArgsConstructor
public class WarehouseListRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    private final QInvWhAreaSettingDO invWhAreaSettingDO = QInvWhAreaSettingDO.invWhAreaSettingDO;

    private final QInvWhDO invWhDO = QInvWhDO.invWhDO;

    public JPAQuery<InvWhRespVO> select(InvWhParamVO param) {
        Predicate predicate = invWhDO.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                invWhDO.id,
                invWhDO.ouId,
                invWhDO.relateOuCode,
                invWhDO.relateOuId,
                invWhDO.buId,
                invWhDO.secBuId,
                invWhDO.secUserId,
                invWhDO.secOuId,
                invWhDO.ownerAddrNo,
                invWhDO.whCode,
                invWhDO.whName,
                invWhDO.whName2,
                invWhDO.whAbbr,
                invWhDO.whType,
                invWhDO.whType2,
                invWhDO.whType3,
                invWhDO.whStatus,
                invWhDO.whStatus2,
                invWhDO.thirdplFlag,
                invWhDO.physicalWhCode,
                invWhDO.businessCode,
                invWhDO.erpCode,
                invWhDO.delivery,
                invWhDO.deliveryArea,
                invWhDO.addrNo,
                invWhDO.addressId,
                invWhDO.pid,
                invWhDO.whPath,
                invWhDO.es1,
                invWhDO.tenantId,
                invWhDO.remark,
                invWhDO.createUserId,
                invWhDO.createTime,
                invWhDO.modifyUserId,
                invWhDO.modifyTime,
                invWhDO.deleteFlag,
                invWhDO.auditDataVersion,
                invWhDO.area,
                invWhDO.structure,
                invWhDO.fixedAssets,
                invWhDO.plateformFlag,
                invWhDO.fileCode,
                invWhDO.jdbadFlag,
                invWhDO.jdrelateCode,
                invWhDO.jdsybCode,
                invWhDO.jdwhCode,
                invWhDO.tuihuoFlag
        )).from(invWhDO);
        if (param != null) {
            jpaQuery.where(/*where(param)*/);
        }
        jpaQuery.where(predicate, invWhDO.deleteFlag.eq(0).or(invWhDO.deleteFlag.isNull()));
        return jpaQuery;
    }
}
