package com.elitesland.yst.production.inv.infr.repo.scene;

import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.param.InvSceneConfigQueryParam;
import com.elitesland.yst.production.inv.domain.entity.scene.InvSceneConfigDO;
import com.elitesland.yst.production.inv.domain.entity.scene.QInvSceneConfigDO;
import com.elitesland.yst.production.inv.domain.entity.scene.QInvSceneConfigDtlDO;
import com.elitesland.yst.production.inv.infr.repo.JpaQueryProcInterface;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/20 17:21
 */
@Slf4j
@Component
@AllArgsConstructor
public class InvSceneConfigRepoProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;

    public void updateDynamically(InvSceneConfigDO param) {
        val jpaQDO = QInvSceneConfigDO.invSceneConfigDO;
        JPAUpdateClause updateClause = jpaQueryFactory.update(jpaQDO);
        if(StringUtils.isNotBlank(param.getIsEnable())){
            updateClause.set(jpaQDO.isEnable, param.getIsEnable());
        }
        if(StringUtils.isNotBlank(param.getOptDocDesc())){
            updateClause.set(jpaQDO.optDocDesc, param.getOptDocDesc());
        }
        if(StringUtils.isNotBlank(param.getOptDocType())){
            updateClause.set(jpaQDO.optDocType, param.getOptDocType());
        }
        if(StringUtils.isNotBlank(param.getSceneCode())){
            updateClause.set(jpaQDO.sceneCode, param.getSceneCode());
        }
        if(StringUtils.isNotBlank(param.getSceneDesc())){
            updateClause.set(jpaQDO.sceneDesc, param.getSceneDesc());
        }
        updateClause.set(jpaQDO.modifyTime, LocalDateTime.now());
        updateClause.where(jpaQDO.id.eq(param.getId())).execute();
    }

    public PagingVO<InvSceneConfigPageVO> searchPage(InvSceneConfigQueryParam param) {
        val jpaQDo = QInvSceneConfigDO.invSceneConfigDO;
        val jpaDQDo = QInvSceneConfigDtlDO.invSceneConfigDtlDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvSceneConfigPageVO.class,
                        jpaDQDo.id,
                        jpaQDo.sceneCode,
                        jpaQDo.sceneDesc,
                        jpaQDo.optDocType,
                        jpaQDo.optDocDesc,
                        jpaDQDo.masId,
                        jpaDQDo.ioCode,
                        jpaDQDo.ioType,
                        jpaDQDo.optDesc,
                        jpaDQDo.optSeq,
                        jpaDQDo.isRelDocReq,
                        jpaDQDo.isUseRelDoc,
                        jpaDQDo.relDocType,
                        jpaDQDo.deter2,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaDQDo.whoptType,
                        jpaQDo.auditDataVersion
                )
        ).from(jpaDQDo).leftJoin(jpaQDo).on(jpaQDo.id.eq(jpaDQDo.masId));
        if (param != null) {
            jpaQuery.where(where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return PagingVO.<InvSceneConfigPageVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private Predicate where(InvSceneConfigQueryParam param) {
        val jpaQDo = QInvSceneConfigDO.invSceneConfigDO;
        val jpaDQDo = QInvSceneConfigDtlDO.invSceneConfigDtlDO;
        Predicate predicate = jpaQDo.isNotNull();

        if (StringUtils.isNotBlank(param.getIoCode())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.ioCode.eq(param.getIoCode()));
        }
        if (StringUtils.isNotBlank(param.getIoType())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.ioType.eq(param.getIoType()));
        }
        if (StringUtils.isNotBlank(param.getOptDocDesc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.optDocDesc.like("%" + param.getOptDocDesc() + "%"));
        }
        if (StringUtils.isNotBlank(param.getOptDocType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.optDocType.eq(param.getOptDocType()));
        }
        if (StringUtils.isNotBlank(param.getSceneCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.sceneCode.eq(param.getSceneCode()));
        }
        if (StringUtils.isNotBlank(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    jpaQDo.sceneCode.like("%" + param.getMultiKeywords() + "%"),
                    jpaQDo.sceneDesc.like("%" + param.getMultiKeywords() + "%")
            ));
        }
        return predicate;
    }

}