package com.elitesland.yst.production.inv.application.facade.export.invstk;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author jeesie.jiang
 */
@Data
@ExcelIgnoreUnannotated
@HeadRowHeight(35)
public class InvStkShareExcelRespVO implements Serializable {

    private static final long serialVersionUID = 2052609794116817761L;

    @ApiModelProperty("共享类型")
    @SysCode(sys = "yst-inv",mod = "SHARE_TYPE")
    private String shareType;
    @ApiModelProperty("共享类型名")
    @ExcelProperty("共享类型")
    private String shareTypeName;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    @ExcelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv",mod = "FUNC_TYPE")
    private String deter2;
    @ExcelProperty("功能区")
    private String deter2Name;

    @ApiModelProperty("库存合作伙伴编码")
    @ExcelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作合作伙伴名称")
    @ExcelProperty("库存合作合作伙伴名称")
    private String pName;

    @ApiModelProperty("库存合作类型")
    private String pType;

    @ApiModelProperty("品项编号")
    @ExcelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    @ExcelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("包装规格")
    @ExcelProperty("商品规格")
    private String packageSpec;

    @ApiModelProperty("共享数量")
    @ExcelProperty("共享数量")
    private BigDecimal qty;

    @ApiModelProperty("主计量单位 [UDC]COM:UOM")
    @ExcelProperty("单位")
    private String uom;
    private String uomName;


    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    @ExcelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("共享类型配置参数")
    private BigDecimal shareSetting;


    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;


    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("品类")
    private String itemCateCode;

    @ApiModelProperty("商品类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("库存可用数量")
    private BigDecimal avalQty;


    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;


    @ApiModelProperty("商品批次")
    private String lotNo;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

}
