package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lu.wang
 * @date 2020-08-11 16:10
 * Desc: 库内组装单及明细QP
 */
@Data
@ApiModel(value = "inv_trn", description = "库内组装单及明细QP")
public class InvAsmAllQueryParam extends AbstractOrderQueryParam {

    @ApiModelProperty("仓库ids")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> whIds;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    List<String> deter2s;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("品牌ids")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> brands;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;

    @ApiModelProperty("品项ids")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> itemIds;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("批次号")
    List<String> lotNos;

    @ApiModelProperty("申请日期")
    List<LocalDateTime> applyDates;

    @ApiModelProperty("组装单状态 [UDC]INV:ASM_STATUS")
    String docStatus;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("交易日期 实际出入库日期")
    List<LocalDateTime> ioDates;

    @ApiModelProperty("原因码 [UDC]COM:APPR_STATUS")
    String reasonCode;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("外部单据编号")
    String outerNo;
    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("功能区关键字查询")
    private String deter2KeyWord;

}
