package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 库存预留  查询（共通方法30 入参）
 * </p >
 *
 * @author ssy
 * @date 2020/8/5
 */
@Data
@ApiModel(value = "库存预留  查询（共通方法30 入参）", description = "库存预留  查询（共通方法30 入参）")
public class InvRoCommon30InSaveVO extends InvBaseModel implements Serializable {

    private static final long serialVersionUID = -7726579185856932822L;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("预留单号")
    private String docNo;

    @ApiModelProperty("批次限定个数")
    private Integer maxLotNum;

    @ApiModelProperty("现有数量的判断条件  >、=、<")
    private String opType;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("新鲜度")
    private String fressType;

    @ApiModelProperty("新鲜度要求 (最小允收期)")
    private Double fressTypeDays;

    @ApiModelProperty("调整天数")
    private Double adjustDays;

    @ApiModelProperty("最早批次号")
    private String firstLotNo;

    @ApiModelProperty("品牌编号")
    private String brandCode;

    @ApiModelProperty("预留状态")
    private String docStatus;

    @ApiModelProperty("预留状态多选")
    private List<String> docStatusList;

    @ApiModelProperty("单据状态是否过滤已释放（库存预留单查询专用字段：当该值为true时，取状态 不是已释放 的数据）")
    private Boolean rlStatusFlag;

    @ApiModelProperty("申请日期（开始）")
    private LocalDateTime applyDateS;
    @ApiModelProperty("申请日期（结束）")
    private LocalDateTime applyDateE;

    @ApiModelProperty("预留到期日期（开始）")
    private LocalDateTime rsvDueDateS;
    @ApiModelProperty("预留到期日期（结束）")
    private LocalDateTime rsvDueDateE;

    @ApiModelProperty("发起人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("审批流水号")
    private String applyNo;

    @ApiModelProperty("批次状态 允许的出入库类型,0,可以出，1不可以出")
    private String lotStatus;


    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

}
