package com.elitesland.yst.production.inv.application.facade.vo.carr;



import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author feng
 * @program: yst-inv
 * @description: 配送单查询入参
 * @date 2021-09-23 17:31:36
 */
@Data
@ApiModel(value = "inv_carr", description = "承运商配送单查询")
public class InvCarrQueryParamVO extends AbstractOrderQueryParam {

    @ApiModelProperty("承运商ID")
    private Long carrierSuppId;
    @ApiModelProperty("单据编号(配送单号)")
    private String docNo;
    @ApiModelProperty("关联单据编号(送货单号)")
    private String relateDocNo;
    @ApiModelProperty("商品ids")
    private List<Long> itemIds;
    @ApiModelProperty("单据状态 [UDC]PUR:SS_STATUS")
    private String docStatus;
    @ApiModelProperty("配送日期起")
    private LocalDateTime deliveryDateStart;
    @ApiModelProperty("配送日期止")
    private LocalDateTime deliveryDateEnd;
    @ApiModelProperty("供应商ID(发货单位)")
    private Long suppId;
    @ApiModelProperty("公司ID(收货单位)")
    private Long ouId;
    @ApiModelProperty("创建人")
    private Long createUserId;

}
