package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadStyle;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName InvWhExcelImport
 * @Description 仓库信息导入类
 * @Auther Brian.lai
 * @Date 2021/7/14 2:10
 * @Version 1.0
 **/
//标题背景色
@HeadStyle(fillForegroundColor = 22)
//标题字体大小，是否加粗
@HeadFontStyle(fontHeightInPoints = 13,bold = false)
@Data
@ApiModel(value = "仓库信息导入", description = "仓库信息导入")
public class InvWhExcelImport {

    @ExcelProperty({"仓库导入模板",  "仓库类型"})
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;

    @ExcelProperty({"仓库导入模板",  "仓库编码"})
    @ApiModelProperty("仓库编号")
    private String whCode;

    @ExcelProperty({"仓库导入模板",  "仓库名称"})
    @ApiModelProperty("仓库名称")
    private String whName;

    @ExcelProperty({"仓库导入模板",  "公司编码"})
    @ApiModelProperty("公司编码")
    private String ouCode;

    @ExcelProperty({"仓库导入模板",  "国家"})
    @ApiModelProperty("国家")
    private String country;

    @ExcelProperty({"仓库导入模板",  "省"})
    @ApiModelProperty("省")
    private String province;

    @ExcelProperty({"仓库导入模板",  "市"})
    @ApiModelProperty("市")
    private String city;

    @ExcelProperty({"仓库导入模板",  "区"})
    @ApiModelProperty("区县")
    private String county;

    @ExcelProperty({"仓库导入模板",  "详细地址信息"})
    @ApiModelProperty("详细地址")
    private String detailaddr;

    @ExcelProperty({"仓库导入模板",  "联系人"})
    @ApiModelProperty("仓库联系人")
    private String contPerson;

    @ExcelProperty({"仓库导入模板",  "联系电话"})
    @ApiModelProperty("联系人电话")
    private String tel;

    @ExcelProperty({"仓库导入模板",  "联系人邮箱"})
    @ApiModelProperty("仓库联系人邮箱")
    private String email;

    @ExcelProperty({"仓库导入模板",  "功能区编码"})
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ExcelProperty({"仓库导入模板", "库存合作伙伴编码"})
    @ApiModelProperty("库存合作伙伴编码")
    private String partCode;

    private String pCode;
}
