package com.elitesland.yst.production.inv.application.facade.vo.lot;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 批次主信息（公共方法21 过滤方法入参）
 * </p>
 *
 * @author ssy
 * @since 2020-07-30 09:39:25
 */
@Data
@ApiModel(value = "批次主信息（过滤方法入参）", description = "批次主信息（过滤方法入参）")
public class InvLotCommon21FilterParamVO implements Serializable {

    private static final long serialVersionUID = 4656228026850735086L;

    @ApiModelProperty("已卫检数量")
    private Double sinQty;

    @ApiModelProperty("箱装数,不能为0（若为0，则不考虑箱装数）")
    private Double fclNum;

    // 20201013 朱亮 25的不完全是批次主数据的sinStatus。0：无卫检要求；1：全部卫检；
    // 0什么都不控制   1，用sinQty判断，sinStatus 是all或part
    @ApiModelProperty("卫检状态")
    private String sinStatus;

    @ApiModelProperty("批次限定个数")
    private Integer maxLotNum;

    @ApiModelProperty("要求数量")
    private Double demandNum;

    @ApiModelProperty("新鲜度")
    private String fressType;

    @ApiModelProperty("新鲜度要求（最低允收期天数）")
    private Double fressTypeDays;

    @ApiModelProperty("调整天数")
    private Double adjustDays;

    @ApiModelProperty("最早批次号")
    private String firstLotNo;

    @ApiModelProperty("[锁定标识]锁定/非锁定决定 质量状态为锁定/非锁定的批次号")
    private String qcStatus;

    @ApiModelProperty("批次状态 允许的出入库类型,0,可以出，1不可以出")
    private String lotStatus;

}
