package com.elitesland.yst.production.inv.application.facade.vo.lot;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 批次库存自动分配（公共方法25入参）
 * </p>
 *
 * @author ssy
 * @since 2020-07-29 09:39:25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "批次库存自动分配（公共方法25入参）", description = "批次库存自动分配（公共方法25入参）")
public class InvLotCommon25InSaveVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 1413699772082622766L;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    // 20201013 朱亮 25的不完全是批次主数据的sinStatus。0：无卫检要求；1：全部卫检；
    // 0什么都不控制   1，用sinQty判断，sinStatus 是all或part
    @ApiModelProperty("卫检状态:")
    private String sinStatus;

    @ApiModelProperty("批次限定个数")
    private Integer maxLotNum;

    @ApiModelProperty("要求数量")
    private BigDecimal demandQty;

    @ApiModelProperty("新鲜度要求(最低允收期天数))")
    private Double fressTypeDays;

    @ApiModelProperty("调整天数")
    private Double adjustDays;

    @ApiModelProperty("最早批次号")
    private String firstLotNo;

    @ApiModelProperty("分配单据号")
    private String allocOrderNo;

    @ApiModelProperty("行号")
    private Double lineNo;

    @ApiModelProperty("来源单据类别")
    private String srcDocCls;

    @ApiModelProperty("来源单据编号")
    private String srcDocNo;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;

    @ApiModelProperty("整箱标识：0：可整可散，1：可整")
    private Integer fclFlag;

    @ApiModelProperty("整箱箱装数")
    private Double fclNum;
}
