package com.elitesland.yst.production.inv.application.out;

import cn.hutool.core.lang.Assert;
import com.alibaba.excel.util.CollectionUtils;
import com.elitesland.yst.production.pur.dto.ss.PurSsDTO;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.yst.production.pur.provider.PurSsProvider;
import com.elitesland.yst.production.pur.provider.PurSuppProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @Description: TODO
 * @Auther: menghua
 * @Date: 2021/5/11
 */
@Service
@AllArgsConstructor
@Slf4j
public class PurDubbleServiceImpl implements PurDubbleService {


    private final PurSuppProvider purSuppProvider;
    private final PurSsProvider purSsProvider;

    /**********************************************outPurService pur模块外部接口*********************************/
    /**
     * 0.00
     * 模糊搜索供应商/客户/员工
     *
     * @param param code=code/name
     * @return 供应商/客户/员工的code和name
     */
   /* @Override
    public List<OrgRespVO> findcodeAndName(InvParentParamVO param) {
        List<OrgRespVO> orgRespVOList = new ArrayList<>();
        try {
            if (UdcEnum.INV_PARTNER_TYPE_CUST.getValueCode().equals(param.getType())) {
                //客户数据暂无
            } else if (UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(param.getType())) {
//                ApiResult<PurSuppBaseDTO> result = purSuppProvider.findBySuppCode(param.getCode());
//                if (result.isSuccess()) {
//                    PurSuppBaseDTO purSuppBaseDTOS = result.getData();
//                    if (purSuppBaseDTOS != null) {
//                        OrgRespVO respVO = this.convertSuppDTOToOrgRespVO(purSuppBaseDTOS);
//                        orgRespVOList.add(respVO);
//
//                    }
//                }
            } else if (UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(param.getType())) {
                OrgEmpRpcDtoParam empParam = new OrgEmpRpcDtoParam();
                List<String> orgemplist = new ArrayList<>();
                orgemplist.add(param.getCode());
                empParam.setEmpCodes(orgemplist);
//                List<OrgEmpRpcDTO> emps = outouService.findEmpDtoByParam(empParam);
//                for (val emp : emps) {
//                    OrgRespVO orgRespVO = new OrgRespVO();
//                    orgRespVO.setId(emp.getId());
//                    orgRespVO.setCode(emp.getEmpCode());
//                    orgRespVO.setName(emp.getEmpName());
//                    orgRespVOList.add(orgRespVO);
//                }
            }
        } catch (Exception e) {
            log.error("findBdIdBatch error:", e);
        }
        return orgRespVOList;
    }*/

   /* private OrgRespVO convertSuppDTOToOrgRespVO(PurSuppBaseDTO purSuppBaseDTO) {
        if (purSuppBaseDTO == null) {
            return null;
        }
        OrgRespVO orgRespVO = new OrgRespVO();
        orgRespVO.setId(purSuppBaseDTO.getId());
        orgRespVO.setName(purSuppBaseDTO.getSuppName());
        orgRespVO.setCode(purSuppBaseDTO.getSuppCode());
        return orgRespVO;
    }*/

    /**
     * 供应商查询
     *
     * @param param 供应商入参
     * @return 供应商结果
     */
    @Override
    public List<PurSuppBaseRpcDTO> findBaseRpcDtoByParam(PurSuppBaseRpcParam param) {
        log.info("根据findBaseRpcDtoByParam查询供应商信息，时间：{}，入参：{}", LocalDateTime.now(), param);
        if (Objects.isNull(param)) {
            return Collections.EMPTY_LIST;
        }
        try {
            ApiResult<List<PurSuppBaseRpcDTO>> apiResult = purSuppProvider.findBaseRpcDtoByParam(param);
            log.info("根据findBaseRpcDtoByParam查询供应商信息，时间：{}，出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                if (!CollectionUtils.isEmpty(apiResult.getData())) {
                    return apiResult.getData();
                }
            }
        } catch (Exception e) {
            log.error("findBaseRpcDtoByParam error:", e);
        }
        return Collections.EMPTY_LIST;
    }

    /**
     * 库存批次- 供应商查询
     *
     * @param suppIds 供应商id集
     * @return 供应商集
     */
    @Override
    public List<PurSuppBaseRpcDTO> findSuppByIdBatch(List<Long> suppIds) {
        if (org.springframework.util.CollectionUtils.isEmpty(suppIds)) {
            return Lists.newArrayList();
        }
        try {
            PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
            purSuppBaseRpcParam.setSuppIds(suppIds);
            ApiResult<List<PurSuppBaseRpcDTO>> apiResult = purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam);
            if (apiResult.isSuccess()) {
                if (!CollectionUtils.isEmpty(apiResult.getData())) {
                    return apiResult.getData();
                }
            }
        } catch (Exception e) {
            log.error("findSuppByIdBatch error:", e);
        }
        return Lists.newArrayList();
    }


    /**
     * 库存批次- 供应商查询
     *
     * @param code 供应商编码
     * @return 供应商集
     */
    @Override
    public Optional<PurSuppBaseRpcDTO> findSuppByCode(String code) {
        log.info("根据供应商编码查询供应商信息，时间：{}，入参：{}", LocalDateTime.now(), code);
        if (StringUtils.isEmpty(code)) {
            return Optional.empty();
        }
        try {
            PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
            purSuppBaseRpcParam.setSuppCodes(Collections.singletonList(code));
            ApiResult<List<PurSuppBaseRpcDTO>> apiResult = purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam);
            if (apiResult.isSuccess()) {
                if (!CollectionUtils.isEmpty(apiResult.getData())) {
                    PurSuppBaseRpcDTO purSuppBaseDTO = apiResult.getData().get(0);
                    return Optional.of(purSuppBaseDTO);
                }
            }
        } catch (Exception e) {
            log.error("findSuppByCode error:", e);
        }
        return Optional.empty();
    }

    /**
     * 库存批次- 供应商查询
     *
     * @param codes 供应商编码集合
     * @return 供应商集
     */
    @Override
    public List<PurSuppBaseRpcDTO> findSuppByCodeBatch(List<String> codes) {
        log.info("根据供应商编码集合查询供应商列表，时间：{}，入参：{}", LocalDateTime.now(), codes);

        if (org.springframework.util.CollectionUtils.isEmpty(codes)) {
            return Collections.EMPTY_LIST;
        }
        try {
            PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
            purSuppBaseRpcParam.setSuppCodes(codes);
            ApiResult<List<PurSuppBaseRpcDTO>> apiResult = purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam);
            if (apiResult.isSuccess()) {
                if (!CollectionUtils.isEmpty(apiResult.getData())) {
                    return apiResult.getData();
                }
            }
        } catch (Exception e) {
            log.error("findSuppByCodeBatch error:", e);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void updateCarrierInfo(PurSsDTO param) {
        ApiResult<Void> apiResult = purSsProvider.updateCarrierInfo(param);
        Assert.isTrue(apiResult.isSuccess(),"更新供应商发货单信息失败");
    }

    @Override
    public void updateIsCarrige(PurSsDTO param) {
        ApiResult<Void> apiResult = purSsProvider.updateIsCarrige(param);
        Assert.isTrue(apiResult.isSuccess(),"更新供应商发货单信息失败");
    }
}
