package com.elitesland.yst.production.inv.application.out;


import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.tms.api.provider.TmsProvider;
import com.elitesland.tms.api.vo.TmsOuQueryParamVO;
import com.elitesland.tms.api.vo.TmsOuRespVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
@AllArgsConstructor
@Slf4j
public class TmsOutServiceImpl implements TmsOutService {

    private final TmsProvider tmsProvider;

    @Override
    public List<TmsOuRespVO> findTmsOuList(TmsOuQueryParamVO tmsOuQueryParamVO) {
        ApiResult<List<TmsOuRespVO>> apiResult = tmsProvider.findTmsOuList(tmsOuQueryParamVO);
        Assert.isTrue(apiResult.isSuccess(),"获取物流公司信息失败");
        return apiResult.getData();
    }
}
