package com.elitesland.yst.production.inv.application.service;

import com.elitesland.yst.production.inv.application.facade.vo.ck.*;
import com.elitescloud.cloudt.common.base.PagingVO;


import java.util.List;

/**
 * @author lvqf
 * @Date 2021/2/18
 * @Description 库存盘点
 */
public interface InvCkService {


    /**
     * 库存盘点保存
     * @param invCkSaveVO
     * @return
     */
    //Long saveInvCk(InvCkSaveVO invCkSaveVO);

    /**
     * 库存盘点和明细保存或提交
     * @param invCkAndCkDSaveVO
     * @return
     */
    Long saveOrSubmitInvCkAndCkD(InvCkAndCkDSaveVO invCkAndCkDSaveVO, boolean isSubmit);

    /**
     * 盘点列表查询
     * @param invCkParamVO
     * @return
     */
    PagingVO<InvCkRespVO> list(InvCkParamVO invCkParamVO);

    /**
     * 审批通过
     * @param id
     */
    void approval(Long id);

    void syncToInvAj(Long id);

    /**
     * 审批拒绝
     * @param id
     */
    void reject(Long id);

    /**
     * 盘点单创建
     * @param invCkCreateParamVO
     */
    void create(InvCkCreateParamVO invCkCreateParamVO);

    /**
     * 查询匹配商品信息
     * @param id
     * @return
     */
    InvCkAndCkDRespVO findInvCkAndCkDInfo(Long id);

    /**
     * 取消
     * @param id
     */
    void cancelInvCk(Long id);

    /**
     * 盘点单列表查询
     * @param invCkParamVO
     * @return
     */
    //List<InvCkDownloadRespVO> findInvCkDownloadVOList(InvCkParamVO invCkParamVO);

    /**
     * 根据盘点单id查询导出明细
     * @param masId
     * @return
     */
    //List<InvCkDDownloadRespVO> findInvCkDDownloadVOList(Long masId);


    //List<InvCkDExcelRespVO> findInvDCkDDownloadVOList2(Long masId);

    /**
     *功能描述  动态获取表头
     * @author Brian.lai
     * @date 2021/7/6
      * @param
     * @return java.util.List<java.util.List<java.lang.String>>
     */
    //List<List<String>> head();
}
