package com.elitesland.yst.production.inv.application.service.impl;


import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAllQueryParam;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDO;
import com.elitesland.yst.production.inv.domain.entity.QInvAsmDO;
import com.elitesland.yst.production.inv.domain.service.InvAsmDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepo;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.application.service.InvAsmProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class InvAsmProcessServiceImpl implements InvAsmProcessService {

    private final InvAsmRepo invAsmRepo;

    private final InvAsmDRepo invAsmDRepo;

    private final InvStkOptBizService invStkOptBizService;

    private final SystemService systemService;


    private final JPAQueryFactory jpaQueryFactory;

    private final InvAsmDomainService invAsmDomainService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(Long id, ProcInstStatus procInstStatus) {
        Optional<InvAsmDO> optionalInvAsmDO = invAsmRepo.findById(id);
        if(optionalInvAsmDO.isEmpty()){
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        QInvAsmDO qInvAsmDO = QInvAsmDO.invAsmDO;
        //2,修改审批状态
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInvAsmDO)
                .set(qInvAsmDO.procInstStatus, procInstStatus)
                .where(qInvAsmDO.id.eq(id));
        //修改单据状态
        switch (procInstStatus) {
            // 未提交
            case NOTSUBMIT:
                // 中断执行
            case INTERRUPT:
                //草稿
                jpaUpdateClause.set(qInvAsmDO.docStatus,UdcEnum.INV_ASM_STATUS_DR.getValueCode());
                break;
            // 审批拒绝
            case REJECTED:
                //拒绝
                jpaUpdateClause.set(qInvAsmDO.docStatus,UdcEnum.INV_ASM_STATUS_RJ.getValueCode());
                break;
            // 作废
            case INVALID:
                jpaUpdateClause.set(qInvAsmDO.docStatus,UdcEnum.INV_ASM_STATUS_CL.getValueCode());
                break;
            // 审批中
            case APPROVING:
                jpaUpdateClause.set(qInvAsmDO.docStatus,UdcEnum.INV_ASM_STATUS_APPING.getValueCode());
                break;
            // 审批通过
            case APPROVED:
                //审批通过
                jpaUpdateClause.set(qInvAsmDO.docStatus,UdcEnum.INV_ASM_STATUS_APPED.getValueCode())
                        .set(qInvAsmDO.approvedTime, LocalDateTime.now())
                        .set(qInvAsmDO.apprUserId, SecurityContextUtil.currentUserId())
                        .set(qInvAsmDO.apprUserName,SecurityContextUtil.currentUserName());
                break;
            default:
                break;
        }
        //修改单据状态
        jpaUpdateClause.execute();
        //4,其他业务
        if(ProcInstStatus.APPROVED.equals(procInstStatus)){
                InvAsmAllQueryParam param = new InvAsmAllQueryParam();
                param.setMasId(id);
                List<InvAsmDDO> invAsmDDOS = invAsmDRepo.findByMasId(id);
                //库存锁定增
                List<InvAsmDDO> invAsmDDOList = invAsmDDOS.stream()
                        .filter(v -> UdcEnum.COM_IO_O.getValueCode().equals(v.getLineType()))
                        .collect(Collectors.toList());
                if(!org.apache.commons.collections4.CollectionUtils.isEmpty(invAsmDDOList)){
                    InvStkCommonOperateDTO stkCommonOperateDTO = getInvStkCommonOperateDTO(invAsmDDOList, optionalInvAsmDO.get(), "ASM001");
                    invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);

                }
            }
    }

    @Override
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = systemService.findUserIdsByFlowRoles(id, customParams);
        ArrayList<String> userStrIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String userStrId = String.valueOf(i);
                userStrIds.add(userStrId);
            });
            return userStrIds;
        }
        return null;
    }

    @Override
    public Long getAsmOuId(String businessKey, String customParams) {
        Optional<InvAsmDTO> invAsmDTOOptional = invAsmDomainService.findIdOne(Long.parseLong(businessKey));
        Long ouId = null;
        if (invAsmDTOOptional.isPresent()) {
            InvAsmDTO invAsmDTO = invAsmDTOOptional.get();
            ouId = invAsmDTO.getOuId();
        }
        return ouId;
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvAsmDDO> invAsmDDOS, InvAsmDO invAsmDO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-",""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        invAsmDDOS.stream().forEach(invAsmDDO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAsmDO.getWhId());
            operateBodyDTO.setItemId(invAsmDDO.getItemId());
            operateBodyDTO.setDeter2(invAsmDO.getDeter2());
            operateBodyDTO.setSrcDocId(invAsmDO.getId());
            operateBodyDTO.setDocNo(invAsmDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAsmDDO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            operateBodyDTO.setLineNo(invAsmDDO.getLineNo());
            operateBodyDTO.setCreateUserId(invAsmDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAsmDDO.getUom());
            operateBodyDTO.setQty(invAsmDDO.getQty());
            operateBodyDTO.setLotNo(invAsmDDO.getLotNo());
            operateBodyDTO.setOuId(invAsmDO.getOuId());
            operateBodyDTO.setVariId(invAsmDDO.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }


}
