package com.elitesland.yst.production.inv.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.*;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvStkSsService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkSsConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkSsDO;
import com.elitesland.yst.production.inv.domain.service.InvStkDomainService;
import com.elitesland.yst.production.inv.domain.service.InvStkSsDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.*;
import java.util.stream.Collectors;

/**
 * @description: 库存快照
 * @author: lvqf
 * @create: 2022-06-17 15:15
 * @Version 1.0
 **/
@Service
@AllArgsConstructor
@Slf4j
public class InvStkSsServiceImpl implements InvStkSsService {

    private final InvStkSsDomainService invStkSsDomainService;
    private final InvWhService invWhService;
    private final ItmOutService itmOutService;
    private final OrgOutService outouService;
    private final SystemService systemService;
    private final InvStkDomainService invStkDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;

    @Autowired
    private TaskExecutor taskExecutor;

    @Autowired
    private  TenantClientProvider tenantClientProvider;

    @Override
    @SysCodeProc
    public PagingVO<InvStkSsRespVO> findStkSsPage(InvStkSsQueryParamVO param) {
        if (!CollectionUtils.isEmpty(param.getBrands()) || StringUtils.hasLength(param.getItemType())
                || StringUtils.hasLength(param.getItemType2())) {
            //商品数据查询
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemType(param.getItemType());
            itmItemPartParam.setItemType2(param.getItemType2());
            List<Long> brandItemIds = itmOutService.findItemIdByParam(itmItemPartParam).stream().collect(Collectors.toList());
            //1.brandItemIds长度为0说明没有数据,所以直接返回空 ; 2.长度不为0说明有数据,放入param进行查询
            if (CollectionUtils.isEmpty(brandItemIds)) {
                return PagingVO.<InvStkSsRespVO>builder().total(0L).records(new ArrayList<>()).build();
            }
            param.setItemIds(brandItemIds);
        }
        val pagingVo = invStkSsDomainService.findStkSs(param);
        if (CollectionUtils.isEmpty(pagingVo.getRecords())) {
            return PagingVO.<InvStkSsRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        val vos = pagingVo.getRecords();
        List<InvStkSsRespVO> invStkSsRespVOS = vos.stream().map(
                InvStkSsConvert.INSTANCE :: dtoToRespVO).collect(Collectors.toList());

        stkGroupResults(invStkSsRespVOS);

        return PagingVO.<InvStkSsRespVO>builder()
                .total(pagingVo.getTotal())
                .records(invStkSsRespVOS)
                .build();
    }


    @Override
    public void createStkSs(LocalDateTime ssTime, TenantDataIsolateProvider tenantDataIsolateProvider) {
        ssTime = Objects.isNull(ssTime) ? LocalDateTime.now() : ssTime;
        List<InvStkSsDO> invStkDTOS = this.tesk(ssTime,tenantDataIsolateProvider);
        log.info("获取数据库数据{}", JSON.toJSONString(invStkDTOS));
        if (CollectionUtils.isEmpty(invStkDTOS)){
            log.info("未查询到库存数据!");
        }else{
            invStkSsDomainService.saveInvStkList(invStkDTOS);
        }
    }

    public List<InvStkSsDO> tesk(LocalDateTime ssTime,TenantDataIsolateProvider tenantDataIsolateProvider){
        //分页查询出total
        InvStkQueryParamVO invStkQueryParamVO = new InvStkQueryParamVO();
        invStkQueryParamVO.setCurrent(1);
        invStkQueryParamVO.setSize(1);
        PagingVO<InvStkDTO> pagingVO = invStkDomainService.queryAll(invStkQueryParamVO);
        int total =(int)pagingVO.getTotal();
        SysTenantDTO sessionTenant = tenantClientProvider.getSessionTenant();
        //按1千分组
        List<InvStkQueryParamVO> invStkQueryParamVOS = splitList(total, 1000);
        List<InvStkSsDO> need=new ArrayList<>();
        try {
            for (InvStkQueryParamVO voList : invStkQueryParamVOS) {
                CompletableFuture<List<InvStkSsDO>> future = CompletableFuture.supplyAsync(() -> setNeed( voList, ssTime,tenantDataIsolateProvider,sessionTenant),
                        taskExecutor);
                try {
                    if (future != null) {
                        List<InvStkSsDO> invStkSsDOS = future.get();
                        need.addAll(invStkSsDOS);
                    }
                } catch (InterruptedException | ExecutionException e) {
                    throw new BusinessException("线程获取数据失败:" + e.getMessage());
                }
            }
        } catch (Exception e) {
            log.error("多线程执行失败", e);
            throw new BusinessException("多线程执行失败:" + e.getMessage());
        }
        return need;
    }
    private List<InvStkSsDO>  setNeed(InvStkQueryParamVO paramVO,LocalDateTime ssTime,TenantDataIsolateProvider tenantDataIsolateProvider,SysTenantDTO sessionTenant){
        //手动放置租户ID
      return   tenantDataIsolateProvider.byTenantDirectly(()->{
            List<InvStkDTO> records = invStkDomainService.queryAll(paramVO).getRecords();
            return records.stream().map(stkDTO -> {
                InvStkSsDO invStkSsDO = InvStkSsConvert.INSTANCE.stkDtoToDO(stkDTO);
                invStkSsDO.setId(null);
                invStkSsDO.setStkSsTime(ssTime);
                return invStkSsDO;
            }).collect(Collectors.toList());
        },sessionTenant);
    }
    /**
     * 拆分list为指定长度的list
     *
     * @param groupSize  拆分长度
     * @return List<List < T>>
     */
    private List<InvStkQueryParamVO> splitList(int length, int groupSize) {
        List<InvStkQueryParamVO> need=new ArrayList<>();
        int u=length % groupSize;
        int i=0;
        if(u>0){
             i=(length / groupSize)+1;
        }else{
            i=length / groupSize;
        }
        if (i < 1||i==1) {
            InvStkQueryParamVO invStkQueryParamVO = new InvStkQueryParamVO();
            invStkQueryParamVO.setCurrent(1);
            invStkQueryParamVO.setSize(groupSize);
            need.add(invStkQueryParamVO);
        } else {
            for (int j = 0; j < i; j++) {
                InvStkQueryParamVO invStkQueryParamVO = new InvStkQueryParamVO();
                invStkQueryParamVO.setSize(groupSize);
                invStkQueryParamVO.setCurrent(j + 1);
                need.add(invStkQueryParamVO);
            }
        }
        return need;
    }

    public void stkGroupResults(List<InvStkSsRespVO> invStkSsRespVOS) {
        List<Long> itemIds = invStkSsRespVOS.stream().map(InvStkSsRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        val itmItemResults = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<Long> userIds = invStkSsRespVOS.stream().map(InvStkSsRespVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = systemService.findAllEmpsByIdIn(userIds);
        List<Long> ouIds = invStkSsRespVOS.stream().map(InvStkSsRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        val orgOuResults = outouService.findOuByIds(ouIds);
        invStkSsRespVOS.stream().forEach(i -> {
            if (!CollectionUtils.isEmpty(empsByIdIn)) {
                empsByIdIn.stream().filter(e -> e.getId().equals(i.getCreateUserId())).findAny().ifPresent(v -> {
                    i.setCreator(v.getUsername());
                });
            }
            itmItemResults.stream().filter(v -> v.getId().equals(i.getItemId()))
                    .findAny().ifPresent(m -> {
                        i.setItemCode(m.getItemCode());
                        i.setItemName(m.getItemName());
                        i.setBrand(m.getBrand());
                        i.setPackageSpec(m.getPackageSpec());
                        i.setSpec(m.getSpec());
                        i.setItemType(m.getItemType());
                        i.setItemType2(m.getItemType2());
                        i.setBrandName(m.getBrandName());
                        i.setBarCode(m.getBarCode());
                        i.setSuppCode(m.getSuppCode());
                        i.setSuppName(m.getSuppName());
                        i.setItemCatePathName(m.getItemCatePathName());
                        if (m.getGuaranteeDays() != null) {
                            i.setExpireDays(m.getGuaranteeDays());
                        }
                    });
            orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId()))
                    .findAny().ifPresent(m -> {
                        i.setOuCode(m.getOuCode());
                        i.setOuName(m.getOuName());
                    });
            if (StringUtils.hasLength(i.getPCode()) && StringUtils.hasLength(i.getPType())) {
                InvParentParamVO paramVO = new InvParentParamVO();
                paramVO.setCode(i.getPCode());
                paramVO.setType(i.getPType());
                List<OrgRespVO> vos = outouService.findcodeAndName(paramVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    i.setPName(vos.get(0).getName());
                }
            }
        });
    }

}
