package com.elitesland.yst.production.inv.application.service.impl;



import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvTrnDService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.entity.InvTrnDDO;
import com.elitesland.yst.production.inv.entity.InvTrnDO;
import com.elitesland.yst.production.inv.entity.QInvTrnDO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDTO;
import com.elitesland.yst.production.inv.infr.repo.InvTrnDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvTrnRepo;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.application.service.InvTrnProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.boot.exception.BusinessException;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;

@Service
@AllArgsConstructor
public class InvTrnProcessServiceImpl implements InvTrnProcessService {

    private final InvTrnDService invTrnDService;
    private final InvTrnRepo invTrnRepo;
    private final InvTrnDRepo invTrnDRepo;
    private final InvStkOptBizService invStkOptBizService;

    private final SystemService systemService;

    private final JPAQueryFactory jpaQueryFactory;
    private final InvTrnDomainService invTrnService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        Optional<InvTrnDO> invTrnVOOptional = invTrnRepo.findById(id);
        if(invTrnVOOptional.isEmpty()){
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }

        QInvTrnDO qInvTrnDO = QInvTrnDO.invTrnDO;

        //2,修改审批状态
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInvTrnDO)
                .set(qInvTrnDO.procInstStatus, procInstStatus)
                .where(qInvTrnDO.id.eq(id));

        //修改单据状态
        switch (procInstStatus) {
            // 未提交
            case NOTSUBMIT:
                // 中断执行
            case INTERRUPT:
                //草稿
                jpaUpdateClause.set(qInvTrnDO.docStatus, UdcEnum.INV_TRN_STATUS_DR.getValueCode());
                break;
            // 审批拒绝
            case REJECTED:
                //拒绝
                jpaUpdateClause.set(qInvTrnDO.docStatus,UdcEnum.INV_TRN_STATUS_RJ.getValueCode());
                break;
            // 作废
            case INVALID:
                jpaUpdateClause.set(qInvTrnDO.docStatus,UdcEnum.INV_TRN_STATUS_CL.getValueCode());
                break;
            // 审批中
            case APPROVING:
                jpaUpdateClause.set(qInvTrnDO.docStatus,UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
                break;
            // 审批通过
            case APPROVED:
                //审批通过
                jpaUpdateClause.set(qInvTrnDO.docStatus,UdcEnum.INV_TRN_STATUS_APPED.getValueCode())
                        .set(qInvTrnDO.approvedTime, LocalDateTime.now());//审批完成时间
                break;
            default:
                break;
    }
    //修改单据状态
    jpaUpdateClause.execute();
    //4,其他业务
    if(ProcInstStatus.APPROVED.equals(procInstStatus)) {
            // 库存锁定增
            List<InvTrnDDO> invTrnDDOS = invTrnDRepo.findByMasId(id);
            InvStkCommonOperateDTO invStkCommonOperateDTO = getInvStkCommonOperateDTO(invTrnDDOS, invTrnVOOptional.get(), "TRN001");
            invStkOptBizService.invStkCommonOperate(invStkCommonOperateDTO);
        }
  }

    @Override
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = systemService.findUserIdsByFlowRoles(id, customParams);
        ArrayList<String> userStrIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach(i -> {
                String userStrId = String.valueOf(i);
                userStrIds.add(userStrId);
            });
            return userStrIds;
        }
        return null;
    }

    @Override
    public Long getTrnOuId(String businessKey, String customParams) {
        Optional<InvTrnDTO> invTrnDTO = invTrnService.findIdOne(Long.valueOf(businessKey));
        Long ouId = null;
        if (invTrnDTO.isPresent()) {
            InvTrnDTO invTrnRespVO = invTrnDTO.get();
            ouId = invTrnRespVO.getOuId();
        }
        return ouId;
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvTrnDDO> invTrnDRespVOS, InvTrnDO invTrnDO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-",""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        invTrnDRespVOS.stream().forEach(invTrnDRespVo -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invTrnDRespVo.getOWhId());
            operateBodyDTO.setItemId(invTrnDRespVo.getItemId());
            operateBodyDTO.setDeter2(invTrnDRespVo.getODeter2());
            operateBodyDTO.setSrcDocId(invTrnDO.getId());
            operateBodyDTO.setDocNo(invTrnDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invTrnDRespVo.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKTRN.getValueCode());
            operateBodyDTO.setLineNo(invTrnDRespVo.getLineNo());
            operateBodyDTO.setCreateUserId(invTrnDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invTrnDRespVo.getUom());
            operateBodyDTO.setQty(invTrnDRespVo.getQty());
            operateBodyDTO.setLotNo(invTrnDRespVo.getLotNo());
            operateBodyDTO.setPCode(invTrnDRespVo.getOPCode());
            operateBodyDTO.setPType(invTrnDRespVo.getOPType());
            operateBodyDTO.setOuId(invTrnDRespVo.getOuId());
            operateBodyDTO.setVariId(invTrnDRespVo.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;

    }



}
