package com.elitesland.yst.production.inv.application.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliveryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliveryRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliverySaveVO;
import com.elitesland.yst.production.inv.application.service.InvWhDeliveryService;
import com.elitesland.yst.production.inv.domain.convert.invwh.InvWhDeliveryConvert;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDeliveryDO;
import com.elitesland.yst.production.inv.domain.service.InvWhDeliveryDomainService;
import com.elitesland.yst.production.inv.infr.repo.InvWhDeliveryRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhDeliveryProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesiie.jiang
 * @since 2021-05-29 14:07:11
 */
@Service("invWhDeliveryService")
@AllArgsConstructor
public class InvWhDeliveryServiceImpl implements InvWhDeliveryService {

    private final InvWhDeliveryRepo invWhDeliveryRepo;

    private final InvWhDeliveryProc invWhDeliveryProc;

    private final InvWhDeliveryDomainService invWhDeliveryDomainService;

    @Override
    public Optional<InvWhDeliveryRespVO> findIdOne(Long id) {
        InvWhDeliveryParamVO param = new InvWhDeliveryParamVO();
        param.setId(id);
        List<InvWhDeliveryRespVO> vos = invWhDeliveryProc.select(param);
        if(!CollectionUtils.isEmpty(vos)){
            return Optional.ofNullable(vos.get(0));
        }
        return Optional.empty();
    }

    @Override
    public PagingVO<InvWhDeliveryRespVO> search(InvWhDeliveryParamVO param) {
        PagingVO<InvWhDeliveryRespVO> pagingResult = invWhDeliveryProc.selectDeliveryPagingResult(param);
        return pagingResult;

    }

    @Override
    public List<InvWhDeliveryRespVO> findByWhId(Long whId) {
        InvWhDeliveryParamVO param = new InvWhDeliveryParamVO();
        param.setWhId(whId);
        List<InvWhDeliveryRespVO> respVOS = invWhDeliveryProc.select(param);
        return respVOS;
    }

    @Override
    @Transactional
    public Long createOne(InvWhDeliverySaveVO objVo) {
        return invWhDeliveryDomainService.saveInvWhDelivery(InvWhDeliveryConvert.INSTANCE.voToDO(objVo)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<InvWhDeliverySaveVO> list) {
        return invWhDeliveryDomainService.saveInvWhDeliveries(list.stream().map(InvWhDeliveryConvert.INSTANCE::voToDO)
                .collect(Collectors.toList()))
                .stream().map(InvWhDeliveryDO::getId).collect(Collectors.toList());
    }
}
