package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigQueryVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.param.InvSceneConfigQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.scene.param.InvSceneConfigSaveParam;
import com.elitesland.yst.production.inv.application.service.InvSceneConfigBizService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/20 18:05
 */
@Validated
@RestController
@RequestMapping("/inv/scene/config")
@Api(value = "库存场景配置", tags = {"库存场景配置"})
@AllArgsConstructor
public class InvSceneConfigController {

    private final InvSceneConfigBizService invSceneConfigBizService;

    @PostMapping("/page")
    @ApiOperation("库存场景配置-分页查询")
    public ApiResult<PagingVO<InvSceneConfigPageVO>> page(@RequestBody InvSceneConfigQueryParam param) {
        val ret = invSceneConfigBizService.searchPage(param);
        return ApiResult.ok(ret);
    }
    @PostMapping("/detail/{masId}")
    @ApiOperation("库存场景配置-详情")
    public ApiResult<InvSceneConfigQueryVO> detail(@PathVariable("masId") Long masId) {
        val ret = invSceneConfigBizService.detail(masId);
        return ApiResult.ok(ret);
    }
    @PostMapping("/save")
    @ApiOperation("库存场景配置-保存/更新")
    public ApiResult<Long> save(@RequestBody InvSceneConfigSaveParam param) {
        return ApiResult.ok(invSceneConfigBizService.saveOrUpdate(param));
    }
    @GetMapping("/del/{masId}")
    @ApiOperation("库存场景配置-删除")
    public ApiResult<Void> del(@PathVariable("masId") Long masId) {
        invSceneConfigBizService.del(masId);
        return ApiResult.ok();
    }
}