package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAndTrnDSaveVO;
import com.elitesland.yst.production.inv.application.service.InvTrnService;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author jeesie.jiang
 * @date 2022-03-17 11:34
 * Desc: 库存转移单
 */
@RestController
@RequestMapping("/inv/invtrn")
@Api(value = "库存转移单", tags = {"库存转移单"})
@AllArgsConstructor
public class InvTrnController {

    private final InvTrnService invTrnService;

    /**
     * 新增数据
     *
     * @param inv 新增数据头信息
     * @return 新增数据情况
     */
    @PostMapping("/add")
    @ApiOperation("创建转移单，同时保存明细")
    public ApiResult<?> add(@RequestBody InvTrnAndTrnDSaveVO inv) {
        Long id = invTrnService.saveInvTrnInfo(inv);
        return ApiResult.ok(String.valueOf(id));
    }

    @GetMapping("/detail/{id}")
    @ApiOperation("库存转移详情")
    public ApiResult<?> detail(@PathVariable Long id){
        return ApiResult.ok(invTrnService.invTrnDetail(id));
    }

    /**
     * 提交转移单
     *
     * @param id 转移id
     * @return 单据id
     */
    @PostMapping("/submit/{id}")
    @ApiOperation("提交转移单")
    public ApiResult<?> submit(@PathVariable Long id) {
        val ret = invTrnService.submit(id);
        return ApiResult.ok(String.valueOf(ret));
    }

    /**
     * 批量取消转移单
     *
     * @param ids 转移单ids
     * @return 取消单据ids
     */
    @PutMapping("/cancel")
    @ApiOperation("批量取消转移单")
    public ApiResult<?> cancelInBatch(@RequestBody List<Long> ids) {
        val ret = invTrnService.updateStatusInBatch(ids, UdcEnum.INV_TRN_STATUS_CL.getValueCode());
        return ApiResult.ok(ret);
    }


}
