package com.elitesland.yst.production.inv.domain.entity.carr;


import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "inv_carr_d")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "inv_carr_d", comment = "承运商配送单明细")
@Data
@Accessors(chain = true)
@ApiModel(value = "inv_carr_d", description = "承运商配送单明细")
public class InvCarrDDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 5535724709177835237L;
    @ApiModelProperty("主表ID")
    @Column(name="mas_id" , columnDefinition = "bigint default 0  comment '主表ID'")
    Long masId;

    @ApiModelProperty("行号")
    @Column(name="line_no" , columnDefinition = "NUMERIC(20,2)   comment '行号'")
    BigDecimal lineNo;

    @ApiModelProperty("采购订单明细ID")
    @Column(name="po_d_id" , columnDefinition = "bigint default 0   comment '采购订单明细ID'")
    Long poDId;

    @ApiModelProperty("品项ID")
    @Column(name="item_id" , columnDefinition = "bigint default 0   comment '品项ID'")
    Long itemId;

    @ApiModelProperty("异构ID")
    @Column(name="vari_id" , columnDefinition = "bigint default 0   comment '异构ID'")
    Long variId;

    @ApiModelProperty("仓库ID")
    @Column(name="wh_id" , columnDefinition = "bigint default 0   comment '仓库ID'")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @Column(name="deter1" , columnDefinition = "varchar(64)  comment '温层 [UDC]INV:TEMP_TYPE'")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name="deter2" , columnDefinition = "varchar(64)  comment '功能区 [UDC]INV:FUNC_TYPE'")
    String deter2;

    @ApiModelProperty("客户标识")
    @Column(name="deter3" , columnDefinition = "varchar(64)  comment '客户标识'")
    String deter3;

    @ApiModelProperty("限定4")
    @Column(name="deter4" , columnDefinition = "varchar(64)  comment '限定4'")
    String deter4;

    @ApiModelProperty("限定5")
    @Column(name="deter5" , columnDefinition = "varchar(64)  comment '限定5'")
    String deter5;

    @ApiModelProperty("限定6")
    @Column(name="deter6" , columnDefinition = "varchar(64)  comment '限定6'")
    String deter6;

    @ApiModelProperty("限定7")
    @Column(name="deter7" , columnDefinition = "varchar(64)  comment '限定7'")
    String deter7;

    @ApiModelProperty("限定8")
    @Column(name="deter8" , columnDefinition = "varchar(64)  comment '限定8'")
    String deter8;

    @ApiModelProperty("库位")
    @Column(name="wh_loc" , columnDefinition = "varchar(64)  comment '库位'")
    String whLoc;

    @ApiModelProperty("货位")
    @Column(name="wh_posi" , columnDefinition = "varchar(64)  comment '货位'")
    String whPosi;

    @ApiModelProperty("发货数量")
    @Column(name="qty" , columnDefinition = "NUMERIC(20,8)   comment '发货数量'")
    BigDecimal qty;

    @ApiModelProperty("已收数量")
    @Column(name="accept_qty" , columnDefinition = "NUMERIC(20,8)   comment '已收数量'")
    BigDecimal acceptQty;

    @ApiModelProperty("单位")
    @Column(name="uom" , columnDefinition = "varchar(10)  comment '单位'")
    String uom;

    @ApiModelProperty("发货数量2")
    @Column(name="qty2" , columnDefinition = "NUMERIC(20,8)   comment '发货数量2'")

    BigDecimal qty2;

    @ApiModelProperty("单位2")
    @Column(name="uom2" , columnDefinition = "varchar(10)  comment '单位2'")
    String uom2;

    @ApiModelProperty("单位转换率")
    @Column(name="uom_ratio" , columnDefinition = "NUMERIC(20,8)   comment '单位转换率'")
    BigDecimal uomRatio;

    @ApiModelProperty("单位转换率2")
    @Column(name="uom_ratio2" , columnDefinition = "NUMERIC(20,8)   comment '单位转换率2'")
    BigDecimal uomRatio2;

    @ApiModelProperty("发货批次")
    @Column(name="lot_no" , columnDefinition = "varchar(64)  comment '发货批次'")
    String lotNo;

    @ApiModelProperty("生产批次")
    @Column(name="menu_lot_no" , columnDefinition = "varchar(64)  comment '生产批次'")
    String menuLotNo;

    @ApiModelProperty("生产日期")
    @Column(name="manu_date" , columnDefinition = "datetime   comment '生产日期'")
    LocalDateTime manuDate;

    @ApiModelProperty("过期日期")
    @Column(name="expire_date" , columnDefinition = "datetime   comment '过期日期'")
    LocalDateTime expireDate;

    @ApiModelProperty("保质期天数")
    @Column(name="expire_days" , columnDefinition = "int(64)  comment '保质期天数'")
    Integer expireDays;

    @ApiModelProperty("剩余效期天数")
    @Column(name="until_expire_days" , columnDefinition = "int(64)  comment '剩余效期天数'")
    Integer untilExpireDays;

    @ApiModelProperty("要求保质期比例")
    @Column(name="demand_fresh_percent" , columnDefinition = "NUMERIC(20,8)   comment '要求保质期比例'")
    BigDecimal demandFreshPercent;

    @ApiModelProperty("最低允收期天数")
    @Column(name="demand_aap_days" , columnDefinition = "int(64)  comment '最低允收期天数'")
    Integer demandAapDays;

    @ApiModelProperty("预计到货时效期天数")
    @Column(name="eta_aap_days" , columnDefinition = "int(64)  comment '预计到货时效期天数'")
    Integer etaAapDays;

    @ApiModelProperty("是否新鲜度合格")
    @Column(name="is_fress_valid" , columnDefinition = "int(10)  comment '是否新鲜度合格'")
    Integer isFressValid;

    @ApiModelProperty("到货保质期比例")
    @Column(name="actual_fresh_percent" , columnDefinition = "NUMERIC(20,8)   comment '到货保质期比例'")
    BigDecimal actualFreshPercent;

    @ApiModelProperty("条码")
    @Column(name="barcode" , columnDefinition = "varchar(64)  comment '条码'")
    String barcode;

    @ApiModelProperty("根ID")
    @Column(name="root_id" , columnDefinition = "bigint default 0   comment '根ID'")
    Long rootId;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @Column(name="relate_doc_cls" , columnDefinition = "varchar(64)  comment '关联单据类别 [UDC]COM:DOC_CLS'")
    String relateDocCls;

    @ApiModelProperty("关联单据类型")
    @Column(name="relate_doc_type" , columnDefinition = "varchar(64)  comment '关联单据类型'")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @Column(name="relate_doc_id" , columnDefinition = "bigint default 0   comment '关联单据ID'")
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    @Column(name="relate_doc_no" , columnDefinition = "varchar(64)  comment '关联单据编号'")
    String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @Column(name="relate_doc_did" , columnDefinition = "bigint default 0  comment '关联单据明细ID'")
    Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    @Column(name="relate_doc_lineno" , columnDefinition = "NUMERIC(20,2)   comment '关联单据行号'")
    BigDecimal relateDocLineno;

    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @Column(name="relate_doc2_cls" , columnDefinition = "varchar(64)  comment '关联单据2类别 [UDC]COM:DOC_CLS'")
    String relateDoc2Cls;

    @ApiModelProperty("关联单据2类型")
    @Column(name="relate_doc2_type" , columnDefinition = "varchar(64)  comment '关联单据2类型'")
    String relateDoc2Type;

    @ApiModelProperty("关联单据2ID")
    @Column(name="relate_doc2_id" , columnDefinition = "bigint default 0   comment '关联单据2ID'")
    Long relateDoc2Id;

    @ApiModelProperty("关联单据2编号")
    @Column(name="relate_doc2_no" , columnDefinition = "varchar(64)  comment '关联单据2编号'")
    String relateDoc2No;

    @ApiModelProperty("关联单据2明细ID")
    @Column(name="relate_doc2_did" , columnDefinition = "bigint default 0   comment '关联单据2明细ID'")
    Long relateDoc2Did;

    @ApiModelProperty("关联单据2行号")
    @Column(name="relate_doc2_lineno" , columnDefinition = "NUMERIC(20,2)   comment '关联单据2行号'")
    BigDecimal relateDoc2Lineno;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    @Column(name="root_doc_cls" , columnDefinition = "varchar(64)  comment '来源单据类别 [UDC]COM:DOC_CLS'")
    String rootDocCls;

    @ApiModelProperty("来源单据类型")
    @Column(name="root_doc_type" , columnDefinition = "varchar(64)  comment '来源单据类型'")
    String rootDocType;

    @ApiModelProperty("来源单据Id")
    @Column(name="root_doc_id" , columnDefinition = "bigint default 0   comment '来源单据Id'")
    Long rootDocId;

    @ApiModelProperty("来源单据编号")
    @Column(name="root_doc_no" , columnDefinition = "varchar(64)  comment '来源单据编号'")
    String rootDocNo;

    @ApiModelProperty("来源单据明细ID")
    @Column(name="root_doc_did" , columnDefinition = "bigint default 0  comment '来源单据明细ID'")
    Long rootDocDid;

    @ApiModelProperty("来源单据行号")
    @Column(name="root_doc_lineno" , columnDefinition = "NUMERIC(20,2)   comment '来源单据行号'")
    BigDecimal rootDocLineno;

    @ApiModelProperty("外部单据编号Id")
    @Column(name = "outer_id", columnDefinition = "bigint default 0  comment '外部单据编号Id'")
    Long outerId;

    @ApiModelProperty("外部单据编号明细Id")
    @Column(name = "outer_did", columnDefinition = "bigint default 0  comment '外部单据编号明细Id'")
    Long outerDid;

    @ApiModelProperty("外部单据类型")
    @Column(name="outer_type" , columnDefinition = "varchar(40)  comment '外部单据类型'")
    String outerType;

    @ApiModelProperty("外部单据编号")
    @Column(name="outer_no" , columnDefinition = "varchar(40)  comment '外部单据编号'")
    String outerNo;

    @ApiModelProperty("外部单据行号")
    @Column(name = "outer_lineno", columnDefinition = "NUMERIC(20,3)   comment '行号'")
    BigDecimal outerLineno;

    @ApiModelProperty("ES1")
    @Column(name="es1" , columnDefinition = "varchar(64)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name="es2" , columnDefinition = "varchar(64)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name="es3" , columnDefinition = "varchar(64)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name="es4" , columnDefinition = "varchar(64)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name="es5" , columnDefinition = "varchar(64)  comment 'ES5'")
    String es5;

    @ApiModelProperty("品牌code")
    @Column(name="dbrand" , columnDefinition = "varchar(64)  comment '品牌'")
    String dbrand;


    @ApiModelProperty("基价")
    @Column(name="base_price" , columnDefinition = "NUMERIC(20,8)   comment '基价'")
    BigDecimal basePrice;;

    @ApiModelProperty("价格类型")
    @Column(name="price_type" , columnDefinition = "varchar(40)  comment '价格类型'")
    String priceType;

    @ApiModelProperty("不含税价格")
    @Column(name="net_price" , columnDefinition = "NUMERIC(20,8)   comment '不含税价格'")
    BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    @Column(name="price" , columnDefinition = "NUMERIC(20,8)   comment '含税单价'")
    BigDecimal price;

    @ApiModelProperty("价格本价格")
    @Column(name="pb_price" , columnDefinition = "NUMERIC(20,8)   comment '价格本价格'")
    BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    @Column(name="pb_curr" , columnDefinition = "varchar(40)  comment '价格本币种'")
    String pbCurr;

    @ApiModelProperty("价格本单位")
    @Column(name="pb_uom" , columnDefinition = "varchar(10)  comment '价格本单位'")
    String pbUom;

    @ApiModelProperty("折扣类型")
    @Column(name="disc_type" , columnDefinition = "varchar(40)  comment '折扣类型'")
    String discType;

    @ApiModelProperty("折扣率")
    @Column(name="disc_ratio" , columnDefinition = "NUMERIC(20,8)   comment '折扣率'")
    BigDecimal discRatio;

    @ApiModelProperty("折扣额")
    @Column(name="disc_amt" , columnDefinition = "NUMERIC(20,2)   comment '折扣额'")
    BigDecimal discAmt;

    @ApiModelProperty("折扣描述")
    @Column(name="disc_desc" , columnDefinition = "varchar(100)  comment '折扣描述'")
    String discDesc;

    @ApiModelProperty("折扣后价格")
    @Column(name="disced_price" , columnDefinition = "NUMERIC(20,8)   comment '折扣后价格'")
    BigDecimal discedPrice;

    @ApiModelProperty("交易单价 折扣后，不含税")
    @Column(name="trans_price" , columnDefinition = "NUMERIC(20,8)   comment '交易单价 折扣后，不含税'")
    BigDecimal transPrice;

    @ApiModelProperty("税码")
    @Column(name="tax_code" , columnDefinition = "varchar(40)  comment '税码'")
    String taxCode;

    @ApiModelProperty("税率编号")
    @Column(name="tax_rate_no" , columnDefinition = "varchar(40)  comment '税率编号'")
    String taxRateNo;

    @ApiModelProperty("税率")
    @Column(name="tax_rate" , columnDefinition = "NUMERIC(20,8)   comment '税率'")
    BigDecimal taxRate;

    @ApiModelProperty("税额")
    @Column(name="tax_amt" , columnDefinition = "NUMERIC(20,2)   comment '税额'")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    @Column(name="amt" , columnDefinition = "NUMERIC(20,2)   comment '含税金额'")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    @Column(name="net_amt" , columnDefinition = "NUMERIC(20,2)   comment '不含税金额'")
    BigDecimal netAmt;

    @ApiModelProperty("外币含不税单价")
    @Column(name="curr_net_price" , columnDefinition = "NUMERIC(20,8)   comment '外币含不税单价'")
    BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    @Column(name="curr_price" , columnDefinition = "NUMERIC(20,8)   comment '外币含税单价'")
    BigDecimal currPrice;

    @ApiModelProperty("外币含税金额")
    @Column(name="curr_amt" , columnDefinition = "NUMERIC(20,2)   comment '外币含税金额'")
    BigDecimal currAmt;

    @ApiModelProperty("本币币种")
    @Column(name="home_curr" , columnDefinition = "varchar(40)  comment '本币币种'")
    String homeCurr;

    @ApiModelProperty("币种")
    @Column(name="curr_code" , columnDefinition = "varchar(40)  comment '币种'")
    String currCode;

    @ApiModelProperty("汇率")
    @Column(name="curr_rate" , columnDefinition = "NUMERIC(20,8)   comment '汇率'")
    BigDecimal currRate;

    @ApiModelProperty("外币不含税金额")
    @Column(name="curr_net_amt" , columnDefinition = "NUMERIC(20,2)   comment '外币不含税金额'")
    BigDecimal currNetAmt;
}
