package com.elitesland.yst.production.inv.domain.entity.despatch;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 01月 04日 4:26 下午
 * @version: 1.0
 */
@Entity
@Table(name = "inv_despatch_config")
@org.hibernate.annotations.Table(appliesTo = "inv_despatch_config", comment = "发货地配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "inv_despatch_config", description = "发货地配置")
public class InvDespatchConfigDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 6658138962551590177L;

    @ApiModelProperty("发货地编码")
    @Column(name = "des_code", columnDefinition = "varchar(64)  comment '发货地编码'")
    private String desCode;

    @ApiModelProperty("发货地名")
    @Column(name = "des_name", columnDefinition = "varchar(64)  comment '发货地名'")
    private String desName;

    @ApiModelProperty("功能区数量")
    @Column(name = "deter2_count", columnDefinition = "int(11)  comment '功能区数量'")
    private Integer deter2Count;

    @ApiModelProperty("启用状态")
    @Column(name = "is_enable", columnDefinition = "varchar(6)  comment '启用状态'")
    private String isEnable;

    @ApiModelProperty("预留字段1")
    @Column(name = "deter1", columnDefinition = "varchar(64)  comment '预留字段1'")
    private String deter1;

    @ApiModelProperty("预留字段3")
    @Column(name = "deter3", columnDefinition = "varchar(64)  comment '预留字段3'")
    private String deter3;

    @ApiModelProperty("预留字段4")
    @Column(name = "deter4", columnDefinition = "varchar(64)  comment '预留字段4'")
    private String deter4;

    @ApiModelProperty("预留字段5")
    @Column(name = "deter5", columnDefinition = "varchar(64)  comment '预留字段5'")
    private String deter5;

    @ApiModelProperty("预留字段6")
    @Column(name = "deter6", columnDefinition = "varchar(64)  comment '预留字段6'")
    private String deter6;

    @ApiModelProperty("贸易公司白名单标识")
    @Column(name = "trade_company_flag", columnDefinition = "tinyint(1) default 0 comment '贸易公司白名单标识'")
    private Boolean tradeCompanyFlag;
}
