package com.elitesland.yst.production.inv.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author jeesie.jiang
 * @date 2022-03-17 16:22
 * Desc: 库内转移明细
 */
@Entity
@Table(name = "inv_trn_d")
@org.hibernate.annotations.Table(appliesTo = "inv_trn_d", comment = "库内转移明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "INV_TRN_D", description = "库内转移明细")
public class InvTrnDDO extends BaseModel  implements Serializable
{
    private static final long serialVersionUID = 8217178113859302016L;
    @ApiModelProperty("主表ID")
    @Column(name="mas_id" , columnDefinition = "bigint(20)  comment '主表ID'")
    Long masId;

    @ApiModelProperty("行号")
    @Column(columnDefinition = "NUMERIC(20,3)   comment '行号'")
    Double lineNo;

    @ApiModelProperty("行状态")
    @Column(name="line_status" , columnDefinition = "varchar(40)  comment '行状态'")
    String lineStatus;

    @ApiModelProperty("行类型")
    @Column(name="line_type" , columnDefinition = "varchar(40)  comment '行类型'")
    String lineType;

    @ApiModelProperty("从公司ID")
    @Column(name="o_ou_id" , columnDefinition = "bigint(20)  comment '从公司ID'")
    Long oOuId;

    @ApiModelProperty("公司ID")
    @Column(name="ou_id" , columnDefinition = "bigint(20)  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("从仓库ID")
    @Column(name="o_wh_id" , columnDefinition = "bigint(20)  comment '从仓库ID'")
    Long oWhId;

    @ApiModelProperty("从温层 [UDC]INV:TEMP_TYPE")
    @Column(name="o_deter1" , columnDefinition = "varchar(40)  comment '从温层 [UDC]INV:TEMP_TYPE'")
    String oDeter1;

    @ApiModelProperty("从功能区 [UDC]INV:FUNC_TYPE")
    @Column(name="o_deter2" , columnDefinition = "varchar(40)  comment '从功能区 [UDC]INV:FUNC_TYPE'")
    String oDeter2;

    @ApiModelProperty("从客户标识")
    @Column(name="o_deter3" , columnDefinition = "varchar(40)  comment '从客户标识'")
    String oDeter3;

    @ApiModelProperty("从限定4")
    @Column(name="o_deter4" , columnDefinition = "varchar(40)  comment '从限定4'")
    String oDeter4;

    @ApiModelProperty("从限定5")
    @Column(name="o_deter5" , columnDefinition = "varchar(40)  comment '从限定5'")
    String oDeter5;

    @ApiModelProperty("从限定6")
    @Column(name="o_deter6" , columnDefinition = "varchar(40)  comment '从限定6'")
    String oDeter6;

    @ApiModelProperty("从限定7")
    @Column(name="o_deter7" , columnDefinition = "varchar(40)  comment '从限定7'")
    String oDeter7;

    @ApiModelProperty("从限定8")
    @Column(name="o_deter8" , columnDefinition = "varchar(40)  comment '从限定8'")
    String oDeter8;

    @ApiModelProperty("到公司ID")
    @Column(name="i_ou_id" , columnDefinition = "bigint(20)  comment '到公司ID'")
    Long iOuId;

    @ApiModelProperty("到仓库ID")
    @Column(name="i_wh_id" , columnDefinition = "bigint(20)  comment '到仓库ID'")
    Long iWhId;

    @ApiModelProperty("从仓库编码")
    @Column(name = "o_wh_code", columnDefinition = "varchar(200)  comment '从仓库编码'")
    String oWhCode;

    @ApiModelProperty("至仓库编号")
    @Column(name = "i_wh_code", columnDefinition = "varchar(200)  comment '至仓库编号'")
    String iWhCode;

    @ApiModelProperty("到温层 [UDC]INV:TEMP_TYPE")
    @Column(name="i_deter1" , columnDefinition = "varchar(40)  comment '到温层 [UDC]INV:TEMP_TYPE'")
    String iDeter1;

    @ApiModelProperty("到功能区 [UDC]INV:FUNC_TYPE")
    @Column(name="i_deter2" , columnDefinition = "varchar(40)  comment '到功能区 [UDC]INV:FUNC_TYPE'")
    String iDeter2;

    @ApiModelProperty("到客户标识")
    @Column(name="i_deter3" , columnDefinition = "varchar(40)  comment '到客户标识'")
    String iDeter3;

    @ApiModelProperty("到限定4")
    @Column(name="i_deter4" , columnDefinition = "varchar(40)  comment '到限定4'")
    String iDeter4;

    @ApiModelProperty("到限定5")
    @Column(name="i_deter5" , columnDefinition = "varchar(40)  comment '到限定5'")
    String iDeter5;

    @ApiModelProperty("到限定6")
    @Column(name="i_deter6" , columnDefinition = "varchar(40)  comment '到限定6'")
    String iDeter6;

    @ApiModelProperty("到限定7")
    @Column(name="i_deter7" , columnDefinition = "varchar(40)  comment '到限定7'")
    String iDeter7;

    @ApiModelProperty("到限定8")
    @Column(name="i_deter8" , columnDefinition = "varchar(40)  comment '到限定8'")
    String iDeter8;

    @ApiModelProperty("品项ID")
    @Column(name="item_id" , columnDefinition = "bigint(20)  comment '品项ID'")
    Long itemId;

    @ApiModelProperty("异构ID")
    @Column(name="vari_id" , columnDefinition = "bigint(20)  comment '异构ID'")
    Long variId;

    @ApiModelProperty("批次")
    @Column(name="lot_no" , columnDefinition = "varchar(40)  comment '批次'")
    String lotNo;

    @ApiModelProperty("序列号")
    @Column(name="sn_no" , columnDefinition = "varchar(40)  comment '序列号'")
    String snNo;

    @ApiModelProperty("单位")
    @Column(name="uom" , columnDefinition = "varchar(10)  comment '单位'")
    String uom;

    @ApiModelProperty("转移数量2")
    @Column(name="qty2" , columnDefinition = "NUMERIC(20,8)  comment '转移数量2'")
    BigDecimal qty2;

    @ApiModelProperty("单位2")
    @Column(name="uom2" , columnDefinition = "varchar(10)  comment '单位2'")
    String uom2;

    @ApiModelProperty("单位转换率")
    @Column(name="uom_ratio" , columnDefinition = "float(20,8)   comment '单位转换率'")
    Float uomRatio;

    @ApiModelProperty("单位转换率2")
    @Column(name="uom_ratio2" , columnDefinition = "float(20,8)   comment '单位转换率2'")
    Float uomRatio2;

    @ApiModelProperty("总数量")
    @Column(name="qty" , columnDefinition = "NUMERIC(20,8)  comment '总数量'")
    BigDecimal qty;

    @ApiModelProperty("数量单位")
    @Column(name="qty_uom" , columnDefinition = "varchar(10)  comment '数量单位'")
    String qtyUom;

    @ApiModelProperty("税额")
    @Column(name="tax_amt" , columnDefinition = "NUMERIC(20,4)   comment '税额'")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    @Column(name="amt" , columnDefinition = "NUMERIC(20,4)   comment '含税金额'")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    @Column(name="net_amt" , columnDefinition = "NUMERIC(20,4)   comment '不含税金额'")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    @Column(name="home_curr" , columnDefinition = "varchar(10)  comment '记账币种'")
    String homeCurr;

    @ApiModelProperty("交易币种")
    @Column(name="curr_code" , columnDefinition = "varchar(10)  comment '交易币种'")
    String currCode;

    @ApiModelProperty("汇率")
    @Column(name="curr_rate" , columnDefinition = "NUMERIC(20,8)   comment '汇率'")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    @Column(name="curr_net_amt" , columnDefinition = "NUMERIC(20,4)   comment '外币不含税金额'")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    @Column(name="curr_amt" , columnDefinition = "NUMERIC(20,4)   comment '外币含税金额'")
    BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    @Column(name="cost_price" , columnDefinition = "NUMERIC(20,4)   comment '单位成本'")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    @Column(name="cost_amt" , columnDefinition = "NUMERIC(20,4)   comment '成本金额'")
    BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 如RMA。[UDC]COM:DOC_CLS")
    @Column(name="relate_doc_cls" , columnDefinition = "varchar(40)  comment '关联单据类别 如RMA。[UDC]COM:DOC_CLS'")
    String relateDocCls;

    @ApiModelProperty("关联单据类型")
    @Column(name="relate_doc_type" , columnDefinition = "varchar(40)  comment '关联单据类型'")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @Column(name="relate_doc_id" , columnDefinition = "bigint(20)  comment '关联单据ID'")
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    @Column(name="relate_doc_no" , columnDefinition = "varchar(40)  comment '关联单据编号'")
    String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @Column(name="relate_doc_did" , columnDefinition = "int(18)  comment '关联单据明细ID'")
    Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    @Column(name="relate_doc_lineno" , columnDefinition = "float(20,2)   comment '关联单据行号'")
    Double relateDocLineno;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    @Column(name = "reason_code", columnDefinition = "varchar(40)  comment '原因码 [UDC]COM:REASON_CODE'")
    String reasonCode;

    @ApiModelProperty("外部单据公司")
    @Column(name="outer_ou" , columnDefinition = "varchar(40)  comment '外部单据公司'")
    String outerOu;

    @ApiModelProperty("外部单据类型")
    @Column(name="outer_type" , columnDefinition = "varchar(40)  comment '外部单据类型'")
    String outerType;

    @ApiModelProperty("外部单据编号")
    @Column(name="outer_no" , columnDefinition = "varchar(40)  comment '外部单据编号'")
    String outerNo;

    @ApiModelProperty("外部单据行号")
    @Column(name="outer_lineno" , columnDefinition = "varchar(40)  comment '外部单据行号'")
    String outerLineno;

    @ApiModelProperty("WMS单据号")
    @Column(name="wms_no" , columnDefinition = "varchar(40)  comment 'WMS单据号'")
    String wmsNo;

    @ApiModelProperty("WMS单据行号")
    @Column(name="wms_lineno" , columnDefinition = "varchar(40)  comment 'WMS单据行号'")
    String wmsLineno;

    @ApiModelProperty("从库存合作伙伴编码")
    @Column(name="o_p_code" , columnDefinition = "varchar(20)  comment '从库存合作伙伴编码'")
    String oPCode;

    @ApiModelProperty("至库存合作伙伴编码")
    @Column(name="i_p_code" , columnDefinition = "varchar(20)  comment '至库存合作伙伴编码'")
    String iPCode;

    @ApiModelProperty("库存合作伙伴类型")
    @Column(name="o_p_type" , columnDefinition = "varchar(20)  comment '从库存合作伙伴类型'")
    String oPType;

    @ApiModelProperty("库存合作伙伴类型")
    @Column(name="i_p_type" , columnDefinition = "varchar(20)  comment '至库存合作伙伴类型'")
    String iPType;

    @ApiModelProperty("从包")
    @Column(name="olimit1" , columnDefinition = "varchar(40)  comment '从包'")
    String olimit1;

    @ApiModelProperty("到包")
    @Column(name="ilimit1" , columnDefinition = "varchar(40)  comment '到包'")
    String ilimit1;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvTrnDDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvTrnDDO entity = (InvTrnDDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
