package com.elitesland.yst.production.inv.domain.entity.invwh;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.yst.production.inv.utils.invwh.TreeModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "inv_wh")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "inv_wh", comment = "仓库")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "inv_wh", description = "仓库")
public class InvWhDO extends TreeModel implements Serializable {
    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint default 0 comment '公司ID'")
    Long ouId;

    @ApiModelProperty("公司编号")
    @Column(name = "ou_code", columnDefinition = "varchar(64)  comment '公司编号'")
    String ouCode;

    @ApiModelProperty("所属发运地id")
    @Column(name = "des_id", columnDefinition = "bigint default 0 comment '所属发运地id'")
    Long desId;

    @ApiModelProperty("所属发运地编码")
    @Column(name = "des_code", columnDefinition = "varchar(255)  comment '所属发运地编码'")
    String desCode;

    @ApiModelProperty("BUID")
    @Column(name = "bu_id", columnDefinition = "bigint default 0 comment 'BUID'")
    Long buId;

    @ApiModelProperty("所有者地址号 用于寄售库和VMI库，DCH不用")
    @Column(name = "owner_addr_no", columnDefinition = "bigint(20)  comment '所有者地址号 用于寄售库和VMI库，DCH不用'")
    Long ownerAddrNo;

    @ApiModelProperty("仓库编号")
    @Column(name = "wh_code", columnDefinition = "varchar(200)  comment '仓库编号'")
    String whCode;

    @ApiModelProperty("仓库名称")
    @Column(name = "wh_name", columnDefinition = "varchar(40)  comment '仓库名称'")
    String whName;

    @ApiModelProperty("仓库名称2")
    @Column(name = "wh_name2", columnDefinition = "varchar(40)  comment '仓库名称2'")
    String whName2;

    @ApiModelProperty("简称")
    @Column(name = "wh_abbr", columnDefinition = "varchar(40)  comment '简称'")
    String whAbbr;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    @Column(name = "wh_type", columnDefinition = "varchar(40)  comment '仓库类型 [UDC]INV:WH_TYPE'")
    String whType;

    @ApiModelProperty("仓库类型2")
    @Column(name = "wh_type2", columnDefinition = "varchar(40)  comment '仓库类型2'")
    String whType2;

    @ApiModelProperty("仓库类型3")
    @Column(name = "wh_type3", columnDefinition = "varchar(40)  comment '仓库类型3'")
    String whType3;

    @ApiModelProperty("外部仓库类型")
    @Column(name = "other_wh_type", columnDefinition = "varchar(40)  comment '外部仓库类型'")
    private String otherWhType;

    @ApiModelProperty("外部仓库类型编码")
    @Column(name = "other_wh_code", columnDefinition = "varchar(40)  comment '外部仓库类型'")
    private String otherWhCode;

    @ApiModelProperty("所属组织类型")
    @Column(name = "belong_bu_type", columnDefinition = "varchar(40)  comment '外部仓库类型'")
    private String belongBuType;

    @ApiModelProperty("所属组织")
    @Column(name = "belong_bu_id", columnDefinition = "varchar(40)  comment '外部仓库类型'")
    private String belongBuId;

    @ApiModelProperty("仓库状态")
    @Column(name = "wh_status", columnDefinition = "varchar(40)  comment '仓库状态'")
    String whStatus;

    @ApiModelProperty("仓库状态2")
    @Column(name = "wh_status2", columnDefinition = "varchar(40)  comment '仓库状态2'")
    String whStatus2;

    @ApiModelProperty("是否3PL仓库")
    @Column(name = "thirdpl_flag", columnDefinition = "int(18)  comment '是否3PL仓库'")
    Integer thirdplFlag;

    @ApiModelProperty("是否退货仓")
    @Column(name = "tuihuo_flag", columnDefinition = "int(18)  comment '是否退货仓'")
    Integer tuihuoFlag;

    @ApiModelProperty("物理仓编号")
    @Column(name = "physical_wh_code", columnDefinition = "varchar(40)  comment '物理仓编号'")
    String physicalWhCode;

    @ApiModelProperty("地址号 仓库本身的地址号")
    @Column(name = "addr_no", columnDefinition = "bigint(20)  comment '地址号 仓库本身的地址号'")
    Long addrNo;

    @ApiModelProperty("地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.")
    @Column(name = "address_id", columnDefinition = "bigint default 0  comment '地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.'")
    Long addressId;

//    @ApiModelProperty("上级ID")
//    @Column(name = "pid", columnDefinition = "bigint default 0  comment '上级ID'")
//    Long pid;

    @ApiModelProperty("路径")
    @Column(name = "wh_path", columnDefinition = "varchar(200)  comment '路径'")
    String whPath;

    @ApiModelProperty("区域")
    @Column(name = "region", columnDefinition = "varchar(40)  comment '区域'")
    String region;

    @ApiModelProperty("营业厅编码")
    @Column(name = "business_code", columnDefinition = "varchar(40)  comment '营业厅编码'")
    String businessCode;

    @ApiModelProperty("配送方式")
    @Column(name = "delivery", columnDefinition = "varchar(40)  comment '配送方式'")
    String delivery;

    @ApiModelProperty("配送范围")
    @Column(name = "delivery_area", columnDefinition = "varchar(40)  comment '配送范围'")
    String deliveryArea;

    @ApiModelProperty("erp仓库编码")
    @Column(name = "erp_code", columnDefinition = "varchar(40)  comment 'erp仓库编码'")
    String erpCode;

    @ApiModelProperty("erp仓库名")
    @Column(name = "erp_name", columnDefinition = "varchar(40)  comment 'erp仓库名称'")
    String erpName;

    @ApiModelProperty("ES1")
    @Column(name = "es1", columnDefinition = "varchar(40)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name = "es2", columnDefinition = "varchar(40)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name = "es3", columnDefinition = "varchar(40)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name = "es4", columnDefinition = "varchar(40)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name = "es5", columnDefinition = "varchar(40)  comment 'ES5'")
    String es5;

    @ApiModelProperty("ES6")
    @Column(name = "es6", columnDefinition = "varchar(40)  comment 'ES6'")
    String es6;

    @ApiModelProperty("ES7")
    @Column(name = "es7", columnDefinition = "varchar(40)  comment 'ES7'")
    String es7;

    @ApiModelProperty("ES8")
    @Column(name = "es8", columnDefinition = "varchar(40)  comment 'ES8'")
    String es8;

    @ApiModelProperty("ES9")
    @Column(name = "es9", columnDefinition = "varchar(40)  comment 'ES9'")
    String es9;

    @ApiModelProperty("ES10")
    @Column(name = "es10", columnDefinition = "varchar(40)  comment 'ES10'")
    String es10;

    @ApiModelProperty("采购仓库/销售仓库")
    @Column(name = "ee1", columnDefinition = "varchar(40)  comment '采购仓库/销售仓库'")
    String ee1;

    @ApiModelProperty("是否有WMS")
    @Column(name = "ee2", columnDefinition = "varchar(40)  comment '是否有WMS'")
    String ee2;

    @ApiModelProperty("EE3")
    @Column(name = "ee3", columnDefinition = "varchar(40)  comment 'EE3'")
    String ee3;

    @ApiModelProperty("仓库面积")
    @Column(name = "area", columnDefinition = "NUMERIC(20,8)   comment '仓库面积'")
    Double area;

    @ApiModelProperty("仓库结构")
    @Column(name = "structure", columnDefinition = "varchar(40) comment '仓库结构'")
    String structure;

    @ApiModelProperty("是否装卸平台")
    @Column(name = "plateform_flag", columnDefinition = "int(18)  comment '是否装卸平台'")
    Integer plateformFlag;

    @ApiModelProperty("仓库固定资产")
    @Column(name = "fixed_assets", columnDefinition = "varchar(40)  comment '仓库固定资产'")
    String fixedAssets;

    @ApiModelProperty("附件fileCode")
    @Column(name = "file_code", columnDefinition = "varchar(255)  comment '附件fileCode'")
    String fileCode;

    @ApiModelProperty("库区编号")
    @Column(name = "area_code", columnDefinition = "varchar(40)  comment '库区编号'")
    String areaCode;

    @ApiModelProperty("库区名称")
    @Column(name = "area_name", columnDefinition = "varchar(40)  comment '库区名称'")
    String areaName;

    @ApiModelProperty("库区类型")
    @Column(name = "area_type", columnDefinition = "varchar(40)  comment '库区类型'")
    String areaType;

    @ApiModelProperty("库区状态")
    @Column(name = "area_status", columnDefinition = "varchar(40)  comment '库区状态'")
    String areaStatus;

    @ApiModelProperty("供应商合作公司")
    @Column(name = "relate_ou_id", columnDefinition = "bigint default 0 comment '供应商合作公司ID'")
    Long relateOuId;

    @ApiModelProperty("供应商合作公司编号")
    @Column(name = "relate_ou_code", columnDefinition = "varchar(64)  comment '供应商合作公司编号'")
    String relateOuCode;

    @ApiModelProperty("京东事业部编码")
    @Column(name = "jdsyb_code", columnDefinition = "varchar(40)  comment '京东事业部编码'")
    String jdsybCode;

    @ApiModelProperty("京东仓库关联码")
    @Column(name = "jdrelate_code", columnDefinition = "varchar(40)  comment '京东仓库关联码'")
    String jdrelateCode;

    @ApiModelProperty("不良京云仓")
    @Column(name = "jdbad_flag", columnDefinition = "int(11)  comment '不良京云仓'")
    Integer jdbadFlag;

    @ApiModelProperty("京云仓编码")
    @Column(name = "jdwh_code", columnDefinition = "varchar(40)  comment '京云仓编码'")
    String jdwhCode;
}
