package com.elitesland.yst.production.inv.domain.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigWhPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigDtlQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigQueryParam;
import com.elitesland.yst.production.inv.dto.invDes.param.InvDespatchRpcParam;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.InvDespatchConfigDTO;

import java.util.List;

/**
 * @author jeesie
 */
public interface InvDespatchConfigDomainService {
    PagingVO<InvDespatchConfigPageVO> searchPage(InvDespatchConfigQueryParam queryParam);

    List<InvDespatchConfigPageVO> query(InvDespatchConfigQueryParam queryParam);
    InvDespatchConfigDTO findIdOne(Long id);
    Long saveOrUpdate(InvDespatchConfigDTO despatchConfigDTO);
    PagingVO<InvDespatchConfigWhPageVO> searchDespatchWhPage(InvDespatchConfigDtlQueryParam param);
    PagingVO<InvDespatchConfigWhPageVO> newSearchDespatchWhPage(InvDespatchConfigDtlQueryParam param);
    Boolean enableDespatchConfig(List<Long> ids, String isEnable);
    List<InvDespatchConfigRespVO> getDeter2Count(List<String> desCodes);

    List<InvDespatchRpcDTO> findDespatchRpcByParam(InvDespatchRpcParam param);

    List<InvDespatchRpcDTO> findByDesName(String desName);

    List<InvDespatchRpcDTO> findByDesCode(String desCode);

    List<InvDespatchConfigRespVO> findByIdBatch(List<Long> ids);

    List<InvDespatchRpcDTO> findByDesCodeBatch(List<String> desCodes);


    List<InvDespatchRpcDTO> findByDesCodeBatch(List<String> desCodes,Long tenantId);

}
