package com.elitesland.yst.production.inv.domain.service;


import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocParamVO;
import com.elitesland.yst.production.inv.domain.entity.ioc.InvIoc;
import com.elitesland.yst.production.inv.infr.dto.InvIocDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 功能说明:库存操作码
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
public interface InvIocDomainService {

    PagingVO<InvIocDTO> search(InvIocParamVO param);

    Long saveInvIoc(InvIoc InvIoc, Optional<InvIocDTO> optional);

    Optional<InvIocDTO> findById(Long id);

    Optional<InvIocDTO> findByCode(String code);

    List<InvIocDTO> findByIdBatch(List<Long> idList);

    List<InvIocDTO> findByCodeBatch(List<String> codeList);

    List<InvIocDTO> selectByParam(InvIocParamVO param);

    void updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList);
}
