package com.elitesland.yst.production.inv.domain.service;

import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCombineParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvStkDParam;
import com.elitesland.yst.production.inv.domain.entity.lot.InvLot;
import com.elitesland.yst.production.inv.domain.entity.lot.InvLotDO;
import com.elitesland.yst.production.inv.infr.dto.InvLotDTO;
import com.elitesland.yst.production.inv.infr.dto.InvLotStkDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/15
 * @Version 1.0
 * @Content:
 */
public interface InvLotDomainService {

    /**
     * 批次主档批量保存
     *
     * @param list
     * @return
     */
    List<Long> createBatch(List<InvLot> list);

    /**
     * 批次主档保存
     *
     * @param invLot
     * @return
     */
    Long createOne(InvLot invLot);

    /**
     * 批次主档根据入参查询
     *
     * @param queryParam
     * @return
     */
    List<InvLotDTO> findByParam(InvLotParam queryParam);

    /**
     * 批次主档分页查询
     *
     * @param param
     * @return
     */
    PagingVO<InvLotDTO> invLotSearch(InvLotParam param);

    PagingVO<InvLotStkDTO> useSelectD(InvStkDParam param);

    PagingVO<InvLotDTO> findCombine(InvLotCombineParam param);

    /**
     * 根据ID查询 批次主档信息
     *
     * @param id 批次主档ID
     * @return 批次主档对象
     */
    Optional<InvLotDTO> findById(Long id);

    /**
     * 根据ID批量查询 批次主档信息
     *
     * @param ids 批次主档ID
     * @return 批次主档对象
     */
    List<InvLotDTO> findIdBatch(List<Long> ids);

    /**
     * 根据商品ID、批次号查询 批次主档信息
     *
     * @param itmId 商品ID
     * @param lotNo 批次号
     * @return 批次主档对象
     */
    List<InvLotDTO> findAllByItemIdAndLotNo(Long itmId, String lotNo);

    List<InvLotDTO> findAllByItemIdAndLotNoAndVariId(InvLotParam param);

    void updateDeleteFlagById(Integer deleteFlag, Long id);

    void deleteById(Long id);

    void addSinQty(String lotNo, Long itemId, Double sinQty, String sinStatus, String sinNo);

    List<InvLotDO> findByQueryParam(List<String> queryParam);
}
