package com.elitesland.yst.production.inv.domain.service;

import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryGroupParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.ItmInvStkItemRespVO;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.dto.invstk.InvStkAllRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDTO;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDtoParam;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkFullDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkGroupDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

public interface InvStkDomainService {
    InvStkDO saveInvStk(InvStkDO invStkDO);

    List<InvStkDO> saveInvStkList(List<InvStkDO> invStkList);

    int saveInvStkAll(List<InvStkDO> invStkList);

    Optional<InvStkDO> getInvStkById(Long id);

    InvStkDTO getInvStk(InvBaseModel queryParam);

    List<InvStkRpcDTO> findStkAllRpcDTOByParam(InvStkAllRpcDtoParam param);

    List<InvStkRpcDTO> getInvStkRpcDTOByParam(InvStkRpcDtoParam param);

    void deleteById(Long id);

    void deleteBatch(List<Long> list);

    /**
     * 根据仓库id、功能区查询商品数据
     *
     * @param param
     * @return
     */
    List<InvStkDTO> findInvStkRespVOs(InvStkQueryParamVO param);

    List<InvStkGroupDTO> selectInvStkGroupByParam(InvStkQueryGroupParamVO param);

    PagingVO<InvStkGroupDTO> invStkGroupSearch(InvStkQueryGroupParamVO param);

    /**
     * 全量库存分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 库存多条数据
     */
    PagingVO<InvStkFullDTO> fullSearch(InvStkQueryGroupParamVO param);

    List<InvStkGroupDTO> selectInvStkGroupByInvBaseModel(InvBaseModel param);

    PagingVO<InvStkDTO> queryAll(InvStkQueryParamVO param);



}
