package com.elitesland.yst.production.inv.domain.service;

import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhPTypeRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.dto.invwh.*;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

public interface InvWhDomainService {
    Optional<InvWhRespVO> findIdOne(Long id);

    List<InvWhRespVO> findByCodes(List<String> codes);

    List<InvWhRespVO> findIdBatch(List<Long> ids);

    Optional<InvWhDO> findById(Long id);

    InvWhDO saveInvWh(InvWhDO invWhDO);

    Optional<InvWhRespVO> findById(long id);

    void deleteBatch(List<Long> list);

    PagingVO<InvWhRespVO> searchWh(InvWhParamVO param);

    List<InvWhRespVO> searchWhByParam(InvWhParamVO param);

    List<InvWhRespVO> findByWhIds(List<Long> ids);

    InvWhRespVO findByWhId(Long id);

    List<InvWhRpcDTO> findWhRpcDTOByIdBatch(List<Long> ids);

    List<InvWhDetailRpcDTO> findWhRpcDTOByParam(InvWhRpcDtoParam param);

    List<InvWhRpcDTO> findWhPartRpcDTOByParam(InvWhRpcDtoParam param);

    List<InvWhDeliveryRpcDTO> findWhRpcDTOByDelivery(InvWhDeliveryRpcDtoParam param);

    List<InvWhDeliveryRpcDTO> findWhRpcDTOByAllArea(InvWhDeliveryRpcDtoParam param);

    List<InvWhPTypeRespVO> findWhPTypeList(String pType);

    List<InvWhRespVO> select(InvWhParamVO param);

    Optional<InvWhDO>  findWhDOByWhId(Long id);

    Boolean enableWhhConfig(Long id, String whStatus);
}
