package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsQueryParamVO;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkSsConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkSsDO;
import com.elitesland.yst.production.inv.domain.service.InvStkSsDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvStkFullDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkGroupDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkSsDTO;
import com.elitesland.yst.production.inv.infr.repo.InvStkSsRepoProc;
import com.elitesland.yst.production.inv.infr.repo.InvStkSsRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lvqf
 * @description: 库存快照
 * @datetime 2022年 06月 17日 14:48
 * @version: 1.0
 */
@Service
@AllArgsConstructor
public class InvStkSsDomainServiceImpl implements InvStkSsDomainService {


    private final InvStkSsRepo invStkSsRepo;
    private final InvStkSsRepoProc invStkSsRepoProc;
    @Override
    public PagingVO<InvStkSsDTO> findStkSs(InvStkSsQueryParamVO param) {
        JPAQuery<InvStkSsDTO> jpaQuery = invStkSsRepoProc.select(param);
        param.fillOrders(jpaQuery);
        param.setPaging(jpaQuery);
        return PagingVO.<InvStkSsDTO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    @Override
    public void saveInvStkList(List<InvStkSsDO> invStkSsDOS) {
        invStkSsRepo.saveAll(invStkSsDOS);
    }
}
