package com.elitesland.yst.production.inv.infr.dto;

import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/15
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvLotStkDTO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -4456422742666997807L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouCode;
    private String ouName;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("商品条码（自此段来源于品相表的条码字段）")
    String barCode;

    @ApiModelProperty("箱系数")
    private Float en1;

    @ApiModelProperty("品项类型3 [UDC]ITM:ITEM_TYPE3")
    String itemType3;

    @ApiModelProperty("品项类型3 [UDC]ITM:ITEM_TYPE3")
    String itemType3Name;

    @ApiModelProperty("品牌")
    private String brand;
    private String brandName;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("保质期天数")
    @JsonSerialize(using = ToStringSerializer.class)
    Integer storeExpireDays;

    @ApiModelProperty("代理商")
    private String agency;

    @ApiModelProperty("c1name")
    private String c1Name;

    @ApiModelProperty("c2name")
    private String c2Name;

    @ApiModelProperty("E1BP编号")
    private String outerCode;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whCode;
    private String whName;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1Name;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String whArea;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String whAreaName;


    @ApiModelProperty("功能区（暂时使用）")
    String deter2;

    @ApiModelProperty("功能区（暂时使用）")
    String deter2Name;

    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("限定4")
    private String deter4;

    @ApiModelProperty("限定5")
    private String deter5;

    @ApiModelProperty("限定6")
    private String deter6;

    @ApiModelProperty("限定7")
    private String deter7;

    @ApiModelProperty("限定8")
    private String deter8;

    @ApiModelProperty("库位")
    private String whLoc;

    @ApiModelProperty("货位")
    private String whPosi;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("序列号")
    private String snNo;

    @ApiModelProperty("质量状态 [UDC]INV:LOT_QC_STATUS")
    private String qcStatus;

    @ApiModelProperty("质量状态 [UDC]INV:LOT_QC_STATUS")
    private String qcStatusName;

    @ApiModelProperty("入库日期")
    private LocalDateTime inDate;

    @ApiModelProperty("剩余效期天数 每天自动计算")
    private Integer untilExpireDays;

    @ApiModelProperty("生产日")
    private LocalDateTime manuDate;

    @ApiModelProperty("过期日")
    private LocalDateTime expireDate;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("生产批次")
    private String manuLotNo;

    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    private String fressType;

    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    private String fressTypeName;

    @ApiModelProperty("单位 [UDC]COM:UOM")
    private String uom;

    @ApiModelProperty("单位 [UDC]COM:UOM")
    private String uomName;

    @ApiModelProperty("单位2 [UDC]COM:UOM")
    private String uom2;

    @ApiModelProperty("单位2 [UDC]COM:UOM")
    private String uom2Name;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;

    @ApiModelProperty("现有量")
    private BigDecimal ohQty;

    @ApiModelProperty("现有量2")
    private BigDecimal ohQty2;

    @ApiModelProperty("SO硬承诺量 SO已配货")
    private BigDecimal rsvQty;

    @ApiModelProperty("RO预留量 未配货的可用预留量")
    private BigDecimal rsvQty2;

    @ApiModelProperty("预留量3")
    private BigDecimal rsvQty3;

    @ApiModelProperty("预留量4")
    private BigDecimal rsvQty4;

    @ApiModelProperty("锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏")
    private BigDecimal lockQty;

    @ApiModelProperty("锁定量2")
    private BigDecimal lockQty2;

    @ApiModelProperty("锁定量3")
    private BigDecimal lockQty3;

    @ApiModelProperty("锁定量4")
    private BigDecimal lockQty4;

    @ApiModelProperty("在途量")
    private BigDecimal owQty;

    @ApiModelProperty("在途量2")
    private BigDecimal owQty2;

    @ApiModelProperty("在途量3")
    private BigDecimal owQty3;

    @ApiModelProperty("在途量4")
    private BigDecimal owQty4;

    @ApiModelProperty("可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("可用量2")
    private BigDecimal avalQty2;

    @ApiModelProperty("重量单位")
    private String weightUomCode;

    @ApiModelProperty("重量转换率")
    private Double weightRatio;

    @ApiModelProperty("单位体积")
    private Double volume;

    @ApiModelProperty("单位毛重")
    private Double grossWeight;

    @ApiModelProperty("单位净重")
    private Double netWeight;

    @ApiModelProperty("可用数量")
    private BigDecimal tAvalQty;

    @ApiModelProperty("库存数量CT")
    private BigDecimal tOhQty;

    @ApiModelProperty("SO硬承诺量 SO已配货CT")
    private BigDecimal TRsvQty;

    @ApiModelProperty("总体积")
    private Double tVolume;

    @ApiModelProperty("总毛重")
    private Double tGrossWeight;

    @ApiModelProperty("总净重")
    private Double tNetWeight;

    @ApiModelProperty("金额")
    private BigDecimal amt;

    @ApiModelProperty("库存描述")
    private String stkDesc;

    @ApiModelProperty("库存描述2")
    private String stkDesc2;

    @ApiModelProperty("来源单据类别")
    private String srcDocCls;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;

    @ApiModelProperty("来源单据类别2")
    private String srcDocCls2;

    @ApiModelProperty("来源单据ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId2;

    @ApiModelProperty("来源单据明细ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid2;

    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("ES4")
    private String es4;

    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("DATE1")
    private LocalDateTime date1;

    @ApiModelProperty("DATE2")
    private LocalDateTime date2;

    @ApiModelProperty("DATE3")
    private LocalDateTime date3;

    @ApiModelProperty("DATE4")
    private LocalDateTime date4;

    @ApiModelProperty("DATE5")
    private LocalDateTime date5;

    @ApiModelProperty("箱毛重")
    private Float pkgGrossWeight;

    @ApiModelProperty("箱高")
    private Float pkgHeight;

    @ApiModelProperty("箱宽")
    private Float pkgWidth;

    @ApiModelProperty("箱长")
    private Float pkgLength;

    @ApiModelProperty("库存总重")
    private Double stkWeight;

    @ApiModelProperty("库存总体积")
    private Double stkVolume;

    @ApiModelProperty("该批次已卫检单号")
    private String sinNo;

    @ApiModelProperty("该批次已卫检数量")
    private Double sinQty;
    @ApiModelProperty("E1商品编码")
    private String itemOuterCode;

    @ApiModelProperty("供应商")
    private String suppName;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴名称")
    private String pName;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("生产批次")
    private String menuLotNo;

}
