package com.elitesland.yst.production.inv.infr.dto.ck;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/14
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvCkDTO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -1257273767242143275L;

    @ApiModelProperty("盘点单号")
    private String docNo;

    @ApiModelProperty("盘点类型 [UDC]INV:CK_TYPE")
    private String docType;
    @ApiModelProperty("盘点类型名称 [UDC]INV:CK_TYPE")
    private String docTypeName;

    @ApiModelProperty("盘点单状态 [UDC]INV:CK_STATUS")
    private String docStatus;
    @ApiModelProperty("盘点单状态名称")
    private String docStatusName;

    @ApiModelProperty("盘点方式")
    private String docMethod;

    @ApiModelProperty("盘点方式名称")
    private String docMethodName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private  Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("转调整单状态")
    private Integer isAjStatus;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;
    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty(value = "审核人ID")
    private Long apprUserId;

    @ApiModelProperty("审批人名")
    private String apprUserName;

    @ApiModelProperty("单据类别")
    private String docCls;

}
