package com.elitesland.yst.production.inv.infr.repo;

import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAllQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.InvCalCostQueryParam;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.QInvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.QInvAsmDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.infr.dto.InvAsmAndAsmDDTO;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * @author lu.wang
 * @date 2020-08-12 07:58
 * Desc:
 */
@Component
@AllArgsConstructor
public class InvAsmDRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    public Predicate where(InvAsmAllQueryParam param) {
        val jpaQDO = QInvAsmDO.invAsmDO;
        val jpaQDDO = QInvAsmDDO.invAsmDDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDO.isNotNull().or(jpaQDDO.isNotNull());
        if (param.getMasId() != null) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.masId.eq(param.getMasId()));
        }
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docNo.like("%" + param.getDocNo() + "%"));
        }

        if (!CollectionUtils.isEmpty(param.getOuIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.ouId.in(param.getOuIds()));
        }
        if (StringUtils.hasLength(param.getDeter2KeyWord())) {
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    invWhAreaDO.deter2.like("%" + param.getDeter2KeyWord() + "%"),
                    invWhAreaDO.deter2Name.like("%" + param.getDeter2KeyWord() + "%")
            ));
        }

        if (!StringUtils.isEmpty(param.getWhIds()) && param.getWhIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.whId.in(param.getWhIds()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.deter1.eq(param.getDeter1()));
        }
        if (!StringUtils.isEmpty(param.getDeter2s()) && param.getDeter2s().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.deter2.in(param.getDeter2s()));
        }

        if (!StringUtils.isEmpty(param.getDeter3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.deter3.eq(param.getDeter3()));
        }
        //brands
        if (!StringUtils.isEmpty(param.getItemIds()) && param.getItemIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.itemId.in(param.getItemIds()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.lotNo.like("%" + param.getLotNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getLotNos()) && param.getLotNos().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.lotNo.in(param.getLotNos()));
        }
        if (!StringUtils.isEmpty(param.getApplyDates()) && param.getApplyDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.applyDate.between(param.getApplyDates().get(0), param.getApplyDates().get(1)));
        }
        if (!StringUtils.isEmpty(param.getDocStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docStatus.eq(param.getDocStatus()));
        }
        if (!StringUtils.isEmpty(param.getProcInstStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.procInstStatus.eq(param.getProcInstStatus()));
        }
        if (!StringUtils.isEmpty(param.getIoDates()) && param.getIoDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.ioDate.between(param.getIoDates().get(0), param.getIoDates().get(1)));
        }
        if (!StringUtils.isEmpty(param.getReasonCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.reasonCode.eq(param.getReasonCode()));
        }
        if (!StringUtils.isEmpty(param.getDocCls())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docCls.eq(param.getDocCls()));
        }
        if (!StringUtils.isEmpty(param.getOuterNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.outerNo.like("%" + param.getOuterNo() + "%"));
        }

        return predicate;
    }

    public JPAQuery<InvAsmAndAsmDDTO> selectH(InvAsmAllQueryParam param) {
        val invAsmDO = QInvAsmDO.invAsmDO;
        val invAsmDDO = QInvAsmDDO.invAsmDDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        return jpaQueryFactory.select(
                Projections.bean(
                        InvAsmAndAsmDDTO.class,
                        invAsmDDO.id,
                        invAsmDDO.masId,
                        invAsmDDO.createUserId,
                        invAsmDDO.creator,
                        invAsmDDO.createTime,
                        invAsmDDO.modifyUserId,
                        invAsmDDO.modifyTime,
                        invAsmDDO.updater,
                        invAsmDDO.lineType,
                        invAsmDDO.lotNo,
                        invAsmDDO.itemId,
                        invAsmDDO.qty,
                        invAsmDDO.uom,
                        invAsmDDO.outerNo,
                        invAsmDDO.manuLotNo,
                        invAsmDDO.manuDate,
                        invAsmDDO.expireDate,
                        invAsmDDO.outerLineno,
                        invAsmDDO.outerOu,
                        invAsmDDO.outerType,
                        invAsmDO.applyEmpId,
                        invAsmDO.docNo,
                        invAsmDO.docStatus,
                        invAsmDO.ouId,
                        invAsmDO.buId,
                        invAsmDO.docType,
                        invAsmDO.apprStatus,
                        invAsmDO.procInstId,
                        invAsmDO.procInstStatus,
                        invAsmDO.submitTime,
                        invAsmDO.approvedTime,
                        invAsmDO.whId,
                        invAsmDO.deter1,
                        invAsmDO.deter2,
                        invAsmDO.deter3,
                        invAsmDO.applyDate,
                        invAsmDO.ioDate,
                        invAsmDO.remark,
                        invAsmDO.reasonCode,
                        invAsmDO.apprProcInstId,
                        invAsmDO.apprUserId,
                        invAsmDO.apprUserName,
                        invAsmDO.docCls,
                        invAsmDDO.costPrice,
                        invAsmDDO.costAmt,
                        invWhAreaDO.deter2Name
                )
        ).from(invAsmDDO)
                .innerJoin(invAsmDO).on(invAsmDDO.masId.eq(invAsmDO.id))
                .leftJoin(invWhAreaDO).on(invAsmDO.whId.eq(invWhAreaDO.whId)
                        .and(invAsmDO.deter2.eq(invWhAreaDO.deter2)))
                .where(where(param));

    }

    public JPAQuery<InvAsmAndAsmDDTO> selectD(InvAsmAllQueryParam param) {
        val invAsmDO = QInvAsmDO.invAsmDO;
        val invAsmDDO = QInvAsmDDO.invAsmDDO;
        return jpaQueryFactory.select(
                Projections.bean(
                        InvAsmAndAsmDDTO.class,
                        invAsmDDO.id,
                        invAsmDDO.masId,
                        invAsmDDO.lineType,
                        invAsmDDO.creator,
                        invAsmDDO.createUserId,
                        invAsmDDO.lotNo,
                        invAsmDDO.itemId,
                        invAsmDDO.qty,
                        invAsmDDO.uom,
                        invAsmDDO.manuDate,
                        invAsmDDO.expireDate,
                        invAsmDDO.manuLotNo,
                        invAsmDDO.costPrice,
                        invAsmDDO.costAmt,
                        invAsmDDO.outerNo,
                        invAsmDDO.outerLineno,
                        invAsmDDO.outerOu,
                        invAsmDDO.outerType,

                        invAsmDO.reasonCode,
                        invAsmDO.applyDate,
                        invAsmDO.ioDate,
                        invAsmDO.applyEmpId,

                        invAsmDO.docCls,
                        invAsmDO.docNo,
                        invAsmDO.docStatus,
                        invAsmDO.ouId,
                        invAsmDO.buId,
                        invAsmDO.docType,
                        invAsmDO.apprStatus,
                        invAsmDO.procInstId,
                        invAsmDO.procInstStatus,
                        invAsmDO.submitTime,
                        invAsmDO.approvedTime,
                        invAsmDO.apprUserId,
                        invAsmDO.apprUserName,
                        invAsmDO.whId,
                        invAsmDO.deter1,
                        invAsmDO.deter2,
                        invAsmDO.remark
                )
        ).from(invAsmDDO)
                .leftJoin(invAsmDO).on(invAsmDDO.masId.eq(invAsmDO.id))
                .where(where(param));

    }

    public Page<InvAsmDDO> listByCostCal(InvCalCostQueryParam param, Pageable pageable) {
        val invAsmDO = QInvAsmDO.invAsmDO;
        val invAsmDDO = QInvAsmDDO.invAsmDDO;
        QueryResults<InvAsmDDO> invAsmDDOQueryResults = jpaQueryFactory.select(invAsmDDO).from(invAsmDDO)
                .leftJoin(invAsmDO).on(invAsmDDO.masId.eq(invAsmDO.id))
                .where(whereByCostCal(param))
                .offset(pageable.getOffset()).limit(pageable.getPageSize()).fetchResults();
        return new PageImpl<>(invAsmDDOQueryResults.getResults(), pageable, invAsmDDOQueryResults.getTotal());
    }

    private Predicate whereByCostCal(InvCalCostQueryParam param) {
        val jpaQDO = QInvAsmDO.invAsmDO;
        val jpaQDDO = QInvAsmDDO.invAsmDDO;
        Predicate predicate = jpaQDO.isNotNull().or(jpaQDDO.isNotNull());

        if(!StringUtils.isEmpty(param.getOuId())){
            predicate = ExpressionUtils.and(predicate, jpaQDO.ouId.eq(param.getOuId()));
        }
        if(!StringUtils.isEmpty(param.getValidFrom()) && !StringUtils.isEmpty(param.getValidTo())){
            predicate = ExpressionUtils.and(predicate, jpaQDO.ioDate.between(param.getValidFrom(), param.getValidTo()));
        }
        if (!StringUtils.isEmpty(param.getItemIds()) && param.getItemIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.itemId.in(param.getItemIds()));
        }
        predicate = ExpressionUtils.and(predicate, jpaQDO.docStatus.eq(UdcEnum.INV_ASM_STATUS_CF.getValueCode()));

        return predicate;
    }
}
