package com.elitesland.yst.production.inv.infr.repo;

import com.elitesland.yst.production.inv.domain.entity.invstk.InvIoDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import javax.transaction.Transactional;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author ssy
 * @since 2020-08-18 09:34:58
 */
@Repository
public interface InvIoRepo extends JpaRepository<InvIoDO, Long>, QuerydslPredicateExecutor<InvIoDO> {


    /**
     * 通过单号查询
     * @param costCalculateId 单号
     * @return 结果
     */
    List<InvIoDO> findAllByCostCalculateIdIs(String costCalculateId);

    /**
     * 通过业务单号查询
     * @param srcDocNos
     * @return
             */
    List<InvIoDO> findAllBySrcDocNoIn(List<String> srcDocNos);


    /**
     * 通过业务单号及单据类型查询
     * @param srcDocNo
     * @param srcDocCls
     * @return
     */
    List<InvIoDO> findBySrcDocClsAndSrcDocNo(String srcDocNo,String srcDocCls);

    /**
     * 通过批次号查询
     * @param fin4 批次号
     * @return 结果
     */
    List<InvIoDO> findAllByFin4Is(String fin4);

    /**
     * 通过批次号查询-批量
     * @param fin4 批次号
     * @return 结果
     */
    List<InvIoDO> findAllByFin4In(List<String> fin4s);

    /**
     * 通过批次号查询
     * @param fin8 批次号
     * @return 结果
     */
    List<InvIoDO> findAllByFin8Is(String fin8);

    /**
     * 通过批次号 批量查询
     * @param fin8s 批次号
     * @return 结果
     */
    List<InvIoDO> findAllByFin8In(List<String> fin8s);

    /**
     * 通过业务单号查询 模糊查询
     * @param docNo
     * @return
     */
    List<InvIoDO> findBySrcDocNoLike(String docNo);


    /**
     * 批量更新重推数据推送标志
     * @param pushFlag 推送标志
     * @param idList idList
     */
    @Transactional(rollbackOn = Exception.class)
    @Modifying
    @Query("update InvIoDO set fin1 = ?1,fin4 = null where id in (?2)")
    void updateRePush(String pushFlag, List<Long> idList);

    /**
     * 批量更新重推数据推送标志
     * @param pushFlag 推送标志
     * @param idList idList
     */
    @Transactional(rollbackOn = Exception.class)
    @Modifying
    @Query("update InvIoDO set fin5 = ?1,fin8 = null where id in (?2)")
    void updateRePushCostCarry(String pushFlag, List<Long> idList);
}