package com.elitesland.yst.production.inv.infr.repo;

import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsQueryParamVO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvStkSsDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkSsDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Objects;


/**
 * @description:
 * @author: lvqf
 * @create: 2022-06-17 16:27
 * @Version 1.0
 **/
@Component
@AllArgsConstructor
public class InvStkSsRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvStkSsDO jpaQDo =  QInvStkSsDO.invStkSsDO;



    public JPAQuery<InvStkSsDTO> select(InvStkSsQueryParamVO param) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvStkSsDTO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.buId,
                jpaQDo.itemId,
                jpaQDo.variId,
                jpaQDo.itemCode,
                jpaQDo.itemName,
                jpaQDo.stkSsTime,
                jpaQDo.itemCateCode,
                jpaQDo.brand,
                jpaQDo.whId,
                invWhDO.whCode,
                invWhDO.whType,
                invWhDO.whName,
                jpaQDo.deter1,
                jpaQDo.deter2,
                invWhAreaDO.deter2Name,
                invWhAreaDO.deter2Type,
                jpaQDo.deter3,
                jpaQDo.pType.as("PType"),
                jpaQDo.pCode.as("PCode"),
                jpaQDo.uom,
                jpaQDo.ohQty,
                jpaQDo.avalQty,
                jpaQDo.lockQty,
                jpaQDo.rsvQty,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.secOuId,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.limit1,
                jpaQDo.limit2,
                jpaQDo.limit3,
                jpaQDo.auditDataVersion
        )).from(jpaQDo)
                .leftJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaDO).on(jpaQDo.deter2.eq(invWhAreaDO.deter2).and(jpaQDo.whId.eq(invWhAreaDO.whId)));
        if (param != null) {
            jpaQuery.where(whereGroup(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public Predicate whereGroup(InvStkSsQueryParamVO param) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull());

        if (!CollectionUtils.isEmpty(param.getItemIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.in(param.getItemIds()));
        }

        if (!CollectionUtils.isEmpty(param.getItemCodes())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemCode.in(param.getItemCodes()));
        }

        if(StringUtils.hasLength(param.getDeter2KeyWord())){
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    invWhAreaDO.deter2.like("%" + param.getDeter2KeyWord() + "%"),
                    invWhAreaDO.deter2Name.like("%" + param.getDeter2KeyWord() + "%")
            ));
        }
        if(StringUtils.hasLength(param.getWhType())){
            predicate = ExpressionUtils.and(predicate, invWhDO.whType.eq(param.getWhType()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));
        }
        if (!CollectionUtils.isEmpty(param.getOuIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        }

        if (!CollectionUtils.isEmpty(param.getDeter2s())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.in(param.getDeter2s()));
        }

        if (StringUtils.hasLength(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lotNo.like('%' + param.getLotNo() + '%'));
        }
        if (StringUtils.hasLength(param.getLimit1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.limit1.eq(param.getLimit1()));
        }
        if (Objects.nonNull(param.getStkSsTime())){
            predicate = ExpressionUtils.and(predicate,jpaQDo.stkSsTime.eq(param.getStkSsTime()));
        }
        if(Objects.nonNull(param.getStkSsTimeFrom())){
            predicate = ExpressionUtils.and(predicate,jpaQDo.stkSsTime.goe(param.getStkSsTimeFrom()));
        }
        if(Objects.nonNull(param.getStkSsTimeTo())){
            predicate = ExpressionUtils.and(predicate,jpaQDo.stkSsTime.loe(param.getStkSsTimeTo()));
        }

        return predicate;
    }
}
