package com.elitesland.yst.production.inv.infr.repo.ck;


import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkRespVO;
import com.elitesland.yst.production.inv.domain.entity.ck.QInvCkDDO;
import com.elitesland.yst.production.inv.domain.entity.ck.QInvCkDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDTO;
import com.elitesland.yst.production.inv.infr.repo.JpaQueryProcInterface;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;


/**
 * @author lvqf
 * @date 2021-02-10
 */
@Component
@AllArgsConstructor
public class InvCkRepoProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;

    /**
     * 条件查询
     */
    public Predicate where(InvCkParamVO param) {
        val jpaQDo = QInvCkDO.invCkDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (!StringUtils.isEmpty(param.getWhId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.eq(param.getWhId()));
        }
        if (!StringUtils.isEmpty(param.getDeter2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter2.eq(param.getDeter2()));
        }
        if (!StringUtils.isEmpty(param.getCreateTimeStart()) && !StringUtils.isEmpty(param.getCreateTimeEnd())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.between(param.getCreateTimeStart(), param.getCreateTimeEnd()));
        }
        if (!StringUtils.isEmpty(param.getCreateUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
        }

        if (!StringUtils.isEmpty(param.getDocType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.docType.eq(param.getDocType()));
        }
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.docNo.eq(param.getDocNo()));
        }
        if (!StringUtils.isEmpty(param.getDocStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.docStatus.eq(param.getDocStatus()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!CollectionUtils.isEmpty(param.getOuIds())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        }
        if (!StringUtils.isEmpty(param.getProcInstStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.procInstStatus.eq(param.getProcInstStatus()));
        }
        if (!StringUtils.isEmpty(param.getDocMethod())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.docMethod.eq(param.getDocMethod()));
        }
        if (!StringUtils.isEmpty(param.getIsAjStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.isAjStatus.eq(param.getIsAjStatus()));
        }
        if (!CollectionUtils.isEmpty(param.getMasIds())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(param.getMasIds()));
        }


        return predicate;
    }

    public Predicate listWhere(InvCkParamVO param) {
        val invCkDDO = QInvCkDDO.invCkDDO;
        val invCkDO = QInvCkDO.invCkDO;
        Predicate predicate = where(param);
        try {
            Predicate predicateAuth = DataAuthJpaUtil.dataAuthJpaPredicate(invCkDO.getMetadata());
            predicate = ExpressionUtils.and(predicate, predicateAuth);
        } catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "数据权限异常");
        }

        return predicate;
    }

    public JPAQuery<InvCkRespVO> select(InvCkParamVO param) {
        val jpaQDo = QInvCkDO.invCkDO;
        Predicate predicate = jpaQDo.isNotNull();
        JPAQuery<InvCkRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(InvCkRespVO.class,
                jpaQDo.id,
                jpaQDo.applyDate,
                jpaQDo.apprStatus,
                jpaQDo.apprTime,
                jpaQDo.buId,
                jpaQDo.deter2,
                jpaQDo.createUserId,
                jpaQDo.remark,
                jpaQDo.createTime,
                jpaQDo.docNo,
                jpaQDo.docType,
                jpaQDo.ouId,
                jpaQDo.whId,
                jpaQDo.docCls,
                jpaQDo.modifyTime,
                jpaQDo)).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;

    }

    public PagingVO<InvCkRespVO> invCkSearch(InvCkParamVO param) {
        val jpaQDo = QInvCkDO.invCkDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvCkRespVO.class,
                        jpaQDo.id,
                        jpaQDo.ouId,
                        jpaQDo.buId,
                        jpaQDo.docNo,
                        jpaQDo.docType,
                        jpaQDo.docMethod,
                        jpaQDo.docMode,
                        jpaQDo.docStatus,
                        jpaQDo.docDate,
                        jpaQDo.apprStatus,
                        jpaQDo.apprTime,
                        jpaQDo.apprUserId,
                        jpaQDo.apprComment,
                        jpaQDo.applyEmpId,
                        jpaQDo.applyDate,
                        jpaQDo.applyDesc,
                        jpaQDo.ioDate,
                        jpaQDo.whId,
                        jpaQDo.deter1,
                        jpaQDo.deter2,
                        jpaQDo.deter3,
                        jpaQDo.deter4,
                        jpaQDo.deter5,
                        jpaQDo.deter6,
                        jpaQDo.deter7,
                        jpaQDo.deter8,
                        jpaQDo.brand,
                        jpaQDo.itemId,
                        jpaQDo.lotNo,
                        jpaQDo.isAjStatus,
                        jpaQDo.procInstId,
                        jpaQDo.procInstStatus,
                        jpaQDo.submitTime,
                        jpaQDo.approvedTime,
                        jpaQDo.tenantId,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.auditDataVersion,
                        jpaQDo.secBuId,
                        jpaQDo.secUserId,
                        jpaQDo.secOuId,
                        jpaQDo.docCls,
                        invWhDO.whCode,
                        invWhDO.whName

                        )
        ).from(jpaQDo).leftJoin(invWhDO).on(jpaQDo.whId.eq(invWhDO.id));
        if (param != null) {
            jpaQuery.where(listWhere(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return PagingVO.<InvCkRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public void updateDocStatus(Long id, String docStatus) {
        val jpaQDo = QInvCkDO.invCkDO;
        jpaQueryFactory.update(jpaQDo).set(jpaQDo.docStatus, docStatus).where(jpaQDo.id.eq(id)).execute();
    }


    public void updateIsAjStatus(Long id, Integer isAjStatus) {
        val jpaQDo = QInvCkDO.invCkDO;
        jpaQueryFactory.update(jpaQDo).set(jpaQDo.isAjStatus, isAjStatus).where(jpaQDo.id.eq(id)).execute();
    }

    public JPAUpdateClause updateProcInstStatusById(ProcInstStatus procInstStatus, Long id) {
        val jpaQDo = QInvCkDO.invCkDO;
        Predicate predicate = jpaQDo.isNotNull();
        return jpaQueryFactory.update(jpaQDo)
                .set(jpaQDo.procInstStatus, procInstStatus)
                .where(ExpressionUtils.and(predicate, jpaQDo.id.eq(id)));
    }

    public JPAUpdateClause updateProcInstStatusAndDocStatus(String docStatus, ProcInstStatus procInstStatus, Long id) {
        val jpaQDo = QInvCkDO.invCkDO;
        Predicate predicate = jpaQDo.isNotNull();
        return jpaQueryFactory.update(jpaQDo)
                .set(jpaQDo.docStatus, docStatus)//单据状态
                .set(jpaQDo.procInstStatus, procInstStatus)//审核状态
                .where(ExpressionUtils.and(predicate, jpaQDo.id.eq(id)));
    }

    //修改业务审批数据
    public JPAUpdateClause updateProcInst(ProcessInfo processInfo, Long id, String docStatus) {
        val jpaQDo = QInvCkDO.invCkDO;
        //Predicate predicate = jpaQDo.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(jpaQDo)
                .set(jpaQDo.procInstId, processInfo.getProcInstId())
                .set(jpaQDo.submitTime, LocalDateTime.now())
                .where(jpaQDo.id.eq(id));
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(jpaQDo.procInstStatus, ProcInstStatus.APPROVING);
            jpaUpdateClause.set(jpaQDo.docStatus, docStatus);
        }

        return jpaUpdateClause;


    }
}
