package com.elitesland.yst.production.inv.infr.repo.despatch;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigWhPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigDtlQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigQueryParam;
import com.elitesland.yst.production.inv.domain.entity.despatch.QInvDespatchConfigDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.dto.invDes.param.InvDespatchRpcParam;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.infr.repo.JpaQueryProcInterface;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 01月 04日 4:43 下午
 * @version: 1.0
 */
@Component
@AllArgsConstructor
public class InvDespatchConfigProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;

    public PagingVO<InvDespatchConfigPageVO> searchPage(InvDespatchConfigQueryParam param) {
        val jpaQDO = QInvDespatchConfigDO.invDespatchConfigDO;
        JPAQuery<InvDespatchConfigPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                InvDespatchConfigPageVO.class,
                jpaQDO.id,
                jpaQDO.desCode,
                jpaQDO.desName,
                jpaQDO.isEnable,
                jpaQDO.deter2Count,
                jpaQDO.deter1,
                jpaQDO.deter3,
                jpaQDO.deter4,
                jpaQDO.deter5,
                jpaQDO.deter6,
                jpaQDO.remark,
                jpaQDO.createUserId,
                jpaQDO.creator,
                jpaQDO.createTime,
                jpaQDO.modifyUserId,
                jpaQDO.updater,
                jpaQDO.modifyTime,
                jpaQDO.deleteFlag,
                jpaQDO.tenantId,
                jpaQDO.auditDataVersion,
                jpaQDO.secBuId,
                jpaQDO.secOuId,
                jpaQDO.secUserId,
                jpaQDO.belongOrgId,
                jpaQDO.tradeCompanyFlag
        )).from(jpaQDO);
        if(Objects.nonNull(param)){
            jpaQuery.where(where(param));
            param.fillOrders(jpaQuery, jpaQDO);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDO.deleteFlag.eq(0).or(jpaQDO.deleteFlag.isNull()));
        return PagingVO.<InvDespatchConfigPageVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public PagingVO<InvDespatchConfigWhPageVO> searchDespatchWhPage(InvDespatchConfigDtlQueryParam param) {
        val jpaQDO = QInvDespatchConfigDO.invDespatchConfigDO;
        val qInvWhDO = QInvWhDO.invWhDO;
        val qInvWhAreaDO= QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvDespatchConfigWhPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                InvDespatchConfigWhPageVO.class,
                jpaQDO.id,
                jpaQDO.desCode,
                qInvWhDO.id.as("whId"),
                qInvWhAreaDO.id.as("areaId"),
                qInvWhDO.whName,
                qInvWhAreaDO.deter2Name,
                qInvWhDO.whCode,
                qInvWhAreaDO.deter2Type,
                qInvWhAreaDO.deter2,
                qInvWhDO.ouCode,
                qInvWhDO.ouId
        )).from(jpaQDO)
                .innerJoin(qInvWhDO).on(jpaQDO.id.eq(qInvWhDO.desId))
                .innerJoin(qInvWhAreaDO).on(qInvWhDO.id.eq(qInvWhAreaDO.whId));
        if(Objects.nonNull(param)){
            jpaQuery.where(whereDtlParam(param));
            param.fillOrders(jpaQuery, jpaQDO);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDO.deleteFlag.eq(0).or(jpaQDO.deleteFlag.isNull()),
                jpaQDO.id.eq(param.getDesId()));
        return PagingVO.<InvDespatchConfigWhPageVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public PagingVO<InvDespatchConfigWhPageVO> newSearchDespatchWhPage(InvDespatchConfigDtlQueryParam param) {
        val qInvWhDO = QInvWhDO.invWhDO;
        val qInvWhAreaDO= QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvDespatchConfigWhPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                InvDespatchConfigWhPageVO.class,
                qInvWhDO.id.as("whId"),
                qInvWhAreaDO.id.as("areaId"),
                qInvWhDO.whName,
                qInvWhAreaDO.deter2Name,
                qInvWhDO.whCode,
                qInvWhAreaDO.deter2Type,
                qInvWhAreaDO.deter2,
                qInvWhDO.ouCode,
                qInvWhDO.ouId
        )).from(qInvWhDO)
                .innerJoin(qInvWhAreaDO).on(qInvWhDO.id.eq(qInvWhAreaDO.whId));
        if(Objects.nonNull(param)){
            jpaQuery.where(newWhereDtlParam(param));
            param.fillOrders(jpaQuery, qInvWhDO);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(qInvWhDO.deleteFlag.eq(0).or(qInvWhDO.deleteFlag.isNull()));
        return PagingVO.<InvDespatchConfigWhPageVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private Predicate where(InvDespatchConfigQueryParam param) {
        val jpaQDo = QInvDespatchConfigDO.invDespatchConfigDO;
        Predicate predicate = jpaQDo.isNotNull();
        if (StringUtils.isNotBlank(param.getDesCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.desCode.eq(param.getDesCode()));
        }
        if (Objects.nonNull(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(
                    predicate, ExpressionUtils.anyOf(
                            jpaQDo.desName.like('%' + param.getMultiKeywords() + '%'),
                            jpaQDo.desCode.like('%' + param.getMultiKeywords() + '%')
                    ));
        }
        if(!CollectionUtils.isEmpty(param.getDesCodes())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.desCode.in(param.getDesCodes()));
        }
        if (StringUtils.isNotBlank(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter1.eq(param.getDeter1()));
        }
        if(!CollectionUtils.isEmpty(param.getDeter1List())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter1.in(param.getDeter1List()));
        }
        if (Objects.nonNull(param.getTradeCompanyFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.tradeCompanyFlag.eq(param.getTradeCompanyFlag()));
        }
        if (StringUtils.isNotBlank(param.getIsEnable())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.isEnable.eq(param.getIsEnable()));
        }
        return predicate;
    }

    private Predicate whereDtlParam(InvDespatchConfigDtlQueryParam param) {
        val jpaQDo = QInvDespatchConfigDO.invDespatchConfigDO;
        val qInvWhAreaDO= QInvWhAreaDO.invWhAreaDO;
        val qInvWhDO = QInvWhDO.invWhDO;
        Predicate predicate = jpaQDo.isNotNull();
        if (StringUtils.isNotBlank(param.getWhType())) {
            predicate = ExpressionUtils.and(predicate, qInvWhDO.whType.eq(param.getWhType()));
        }
        if (StringUtils.isNotBlank(param.getDeter2Type())) {
            predicate = ExpressionUtils.and(predicate, qInvWhAreaDO.deter2Type.eq(param.getDeter2Type()));
        }
        if(!CollectionUtils.isEmpty(param.getAreaIds())){
            predicate = ExpressionUtils.and(predicate, qInvWhAreaDO.id.in(param.getAreaIds()));
        }
        if (Objects.nonNull(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, qInvWhDO.ouId.eq(param.getOuId()));
        }
        if (Objects.nonNull(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(
                    predicate, ExpressionUtils.anyOf(
                            qInvWhDO.whName.like('%' + param.getMultiKeywords() + '%'),
                            qInvWhDO.whCode.like('%' + param.getMultiKeywords() + '%')
                    ));
        }

        return predicate;
    }

    private Predicate newWhereDtlParam(InvDespatchConfigDtlQueryParam param) {
        val qInvWhAreaDO= QInvWhAreaDO.invWhAreaDO;
        val qInvWhDO = QInvWhDO.invWhDO;
        Predicate predicate = qInvWhDO.isNotNull();
        if (StringUtils.isNotBlank(param.getWhType())) {
            predicate = ExpressionUtils.and(predicate, qInvWhDO.whType.eq(param.getWhType()));
        }
        if (StringUtils.isNotBlank(param.getDeter2Type())) {
            predicate = ExpressionUtils.and(predicate, qInvWhAreaDO.deter2Type.eq(param.getDeter2Type()));
        }
        if(!CollectionUtils.isEmpty(param.getAreaIds())){
            predicate = ExpressionUtils.and(predicate, qInvWhAreaDO.id.in(param.getAreaIds()));
        }
        if (Objects.nonNull(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, qInvWhDO.ouId.eq(param.getOuId()));
        }
        if (Objects.nonNull(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(
                    predicate, ExpressionUtils.anyOf(
                            qInvWhDO.whName.like('%' + param.getMultiKeywords() + '%'),
                            qInvWhDO.whCode.like('%' + param.getMultiKeywords() + '%')
                    ));
        }
        if (StringUtils.isNotBlank(param.getDesCode())){
            predicate = ExpressionUtils.and(predicate, Expressions.booleanTemplate("FIND_IN_SET({0},{1}) >0", param.getDesCode(), qInvWhDO.desCode));

        }

        return predicate;
    }


    public void enableDespatchConfig(List<Long> ids, String isEnable){
        val jpaQDo = QInvDespatchConfigDO.invDespatchConfigDO;
        jpaQueryFactory.update(jpaQDo).set(jpaQDo.isEnable,isEnable)
                .where(jpaQDo.id.in(ids),
                jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull())).execute();

    }

    public void updateDeter2Count(String desCode){
        val jpaQDo = QInvDespatchConfigDO.invDespatchConfigDO;

    }

    public List<InvDespatchConfigWhPageVO> getWhByDesCodes(List<String> desCodes){
        val jpaQDO = QInvDespatchConfigDO.invDespatchConfigDO;
        val invWhDO = QInvWhDO.invWhDO;
        val qInvWhAreaDO= QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvDespatchConfigWhPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(InvDespatchConfigWhPageVO.class,
                invWhDO.id.as("whId"),
                invWhDO.whCode,
                invWhDO.whName,
                invWhDO.desCode,
                qInvWhAreaDO.deter2
        )).from(jpaQDO)
                .innerJoin(invWhDO).on(jpaQDO.desCode.eq(invWhDO.desCode))
                .leftJoin(qInvWhAreaDO).on(invWhDO.id.eq(qInvWhAreaDO.whId));
        jpaQuery.where(jpaQDO.desCode.in(desCodes)
                .and(jpaQDO.deleteFlag.eq(0).or(jpaQDO.deleteFlag.isNull())));
        return jpaQuery.fetch();
    }

    public List<SelectOptionVO> listDespatchConfig(SelectOptionParam selectOptionParam){
        val jpaQDO = QInvDespatchConfigDO.invDespatchConfigDO;
        JPAQuery<SelectOptionVO> jpaQuery = jpaQueryFactory.select(Projections.bean(SelectOptionVO.class,
                jpaQDO.desName.as("value"),
                jpaQDO.desCode.as("code"),
                jpaQDO.id
        )).from(jpaQDO);
        if(selectOptionParam != null){
            jpaQuery.where(whereSelectParam(selectOptionParam));
        }
        if (Objects.nonNull(selectOptionParam.getStatusFlag()) && selectOptionParam.getStatusFlag()){
            jpaQuery.where(jpaQDO.deleteFlag.eq(0).or(jpaQDO.deleteFlag.isNull()));
        }else {
            jpaQuery.where(jpaQDO.deleteFlag.eq(0).or(jpaQDO.deleteFlag.isNull()),
                    jpaQDO.isEnable.eq("Y").or(jpaQDO.isEnable.isNull()));
        }

        return jpaQuery.fetch();
    }

    private Predicate whereSelectParam(SelectOptionParam param) {
        val jpaQDo = QInvDespatchConfigDO.invDespatchConfigDO;
        Predicate predicate = jpaQDo.isNotNull();
        if (StringUtils.isNotBlank(param.getCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.desCode.eq(param.getCode()));
        }
        if (StringUtils.isNotBlank(param.getValue())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.desName.eq(param.getCode()));
        }
        if (Objects.nonNull(param.getKeyWords())) {
            predicate = ExpressionUtils.and(
                    predicate, ExpressionUtils.anyOf(
                            jpaQDo.desName.like('%' + param.getKeyWords() + '%'),
                            jpaQDo.desCode.like('%' + param.getKeyWords() + '%')
                    ));
        }
        if (Objects.nonNull(param.getTradeCompanyFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.tradeCompanyFlag.eq(param.getTradeCompanyFlag()));
        }
        if (StringUtils.isNotBlank(param.getIsEnable())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.isEnable.eq(param.getIsEnable()));
        }
        return predicate;
    }

    public List<InvDespatchRpcDTO> findDespatchRpcByParam(InvDespatchRpcParam param){
        val jpaQDO = QInvDespatchConfigDO.invDespatchConfigDO;
        JPAQuery<InvDespatchRpcDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                InvDespatchRpcDTO.class,
                jpaQDO.id,
                jpaQDO.desCode,
                jpaQDO.desName,
                jpaQDO.isEnable,
                jpaQDO.deter1,
                jpaQDO.deter3,
                jpaQDO.deter4,
                jpaQDO.deter5,
                jpaQDO.deter6,
                jpaQDO.tradeCompanyFlag,
                jpaQDO.tenantId
        )).from(jpaQDO);
        if(param != null){
            jpaQuery.where(whereRpcParam(param));
        }
        jpaQuery.where(jpaQDO.deleteFlag.eq(0).or(jpaQDO.deleteFlag.isNull()));
        return jpaQuery.fetch();

    }

    public List<InvDespatchRpcDTO> findDespatchRpcByParam(InvDespatchRpcParam param,Long tenantId){
        val jpaQDO = QInvDespatchConfigDO.invDespatchConfigDO;
        JPAQuery<InvDespatchRpcDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                InvDespatchRpcDTO.class,
                jpaQDO.id,
                jpaQDO.desCode,
                jpaQDO.desName,
                jpaQDO.isEnable,
                jpaQDO.deter1,
                jpaQDO.deter3,
                jpaQDO.deter4,
                jpaQDO.deter5,
                jpaQDO.deter6,
                jpaQDO.tradeCompanyFlag,
                jpaQDO.tenantId
        )).from(jpaQDO);
        if(param != null){
            jpaQuery.where(whereRpcParam(param));
        }
        if (Objects.nonNull(tenantId)){
            jpaQuery.where(jpaQDO.tenantId.eq(tenantId));
        }

        jpaQuery.where(jpaQDO.deleteFlag.eq(0).or(jpaQDO.deleteFlag.isNull()));
        return jpaQuery.fetch();

    }

    public List<InvDespatchConfigRespVO> findDespatchByIdBatch(List<Long> ids){
        val jpaQDO = QInvDespatchConfigDO.invDespatchConfigDO;
        JPAQuery<InvDespatchConfigRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                InvDespatchConfigRespVO.class,
                jpaQDO.id,
                jpaQDO.desCode,
                jpaQDO.desName,
                jpaQDO.isEnable,
                jpaQDO.deter1,
                jpaQDO.deter3,
                jpaQDO.deter4,
                jpaQDO.deter5,
                jpaQDO.deter6,
                jpaQDO.tradeCompanyFlag,
                jpaQDO.tenantId
        )).from(jpaQDO);
        Predicate predicate1 = jpaQDO.deleteFlag.eq(0).or(jpaQDO.deleteFlag.isNull());
        Predicate predicate2 = jpaQDO.id.in(ids);
        jpaQuery.where(ExpressionUtils.allOf(predicate1,predicate2));
        return jpaQuery.fetch();

    }

    private Predicate whereRpcParam(InvDespatchRpcParam param) {
        val jpaQDo = QInvDespatchConfigDO.invDespatchConfigDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (StringUtils.isNotBlank(param.getDesCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.desCode.eq(param.getDesCode()));
        }
        if (StringUtils.isNotBlank(param.getDesName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.desName.eq(param.getDesName()));
        }
        if (StringUtils.isNotBlank(param.getIsEnable())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.isEnable.eq(param.getIsEnable()));
        }
        if (param.getDesId() != null) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getDesId()));
        }
        if(!CollectionUtils.isEmpty(param.getDesNames())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.desName.in(param.getDesNames()));
        }
        if(!CollectionUtils.isEmpty(param.getDesCodes())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.desCode.in(param.getDesCodes()));
        }
        if(!CollectionUtils.isEmpty(param.getDesIds())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(param.getDesIds()));
        }
        if (Objects.nonNull(param.getTradeCompanyFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.tradeCompanyFlag.eq(param.getTradeCompanyFlag()));
        }
        if (StringUtils.isNotBlank(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter1.eq(param.getDeter1()));
        }
        if(!CollectionUtils.isEmpty(param.getDeter1List())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.deter1.in(param.getDeter1List()));
        }
        if (Objects.nonNull(param.getTradeCompanyFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.tradeCompanyFlag.eq(param.getTradeCompanyFlag()));
        }
        return predicate;
    }

    public List<InvDespatchConfigPageVO> query(InvDespatchConfigQueryParam param) {
        val jpaQDO = QInvDespatchConfigDO.invDespatchConfigDO;
        JPAQuery<InvDespatchConfigPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                InvDespatchConfigPageVO.class,
                jpaQDO.id,
                jpaQDO.desCode,
                jpaQDO.desName,
                jpaQDO.isEnable,
                jpaQDO.deter2Count,
                jpaQDO.deter1,
                jpaQDO.deter3,
                jpaQDO.deter4,
                jpaQDO.deter5,
                jpaQDO.deter6,
                jpaQDO.tradeCompanyFlag,
                jpaQDO.remark,
                jpaQDO.createUserId,
                jpaQDO.creator,
                jpaQDO.createTime,
                jpaQDO.modifyUserId,
                jpaQDO.updater,
                jpaQDO.modifyTime,
                jpaQDO.deleteFlag,
                jpaQDO.tenantId,
                jpaQDO.auditDataVersion,
                jpaQDO.secBuId,
                jpaQDO.secOuId,
                jpaQDO.secUserId,
                jpaQDO.belongOrgId
        )).from(jpaQDO);
        if(Objects.nonNull(param)){
            jpaQuery.where(where(param));
        }
        jpaQuery.where(jpaQDO.deleteFlag.eq(0).or(jpaQDO.deleteFlag.isNull()));
        return jpaQuery.fetch();
    }


}
