package com.elitesland.yst.production.inv.provider;

import com.elitesland.yst.production.inv.Application;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommon21InVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitesland.yst.production.inv.application.service.InvLotCommonService;
import com.elitesland.yst.production.inv.domain.convert.InvLotConvert;
import com.elitesland.yst.production.inv.dto.invlot.param.InvLotCommon21RpcParam;
import com.elitesland.yst.production.inv.dto.invlot.param.InvLotSaveRpcParam;
import com.elitesland.yst.production.inv.dto.invlot.resp.InvLotRpcDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import lombok.AllArgsConstructor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/19 14:51
 */

@AllArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + InvLotProvider.PATH)
public class InvLotProviderImpl implements InvLotProvider{

    private final InvLotCommonService invLotCommonService;

    @Override
    public ApiResult createInvLotInfo(List<InvLotSaveRpcParam> source) {
        List<InvLotSaveVO> invLotSaveVOS = InvLotConvert.INSTANCE.paramToVoList(source);
        return invLotCommonService.createInvLotInfo(invLotSaveVOS);
    }

    @Override
    public Map<Integer, List<InvLotRpcDTO>> getInvLotVOList(List<InvLotCommon21RpcParam> inList) {
        List<InvLotCommon21InVO> inVOList = InvLotConvert.INSTANCE.queryParamToVoList(inList);
        Map<Integer, List<InvLotRespVO>> invLotVOList = invLotCommonService.getInvLotVOList(inVOList);
        Map<Integer, List<InvLotRpcDTO>> result = new HashMap<>();
        for (Integer key : invLotVOList.keySet()) {
            List<InvLotRespVO> invLotRespVOS = invLotVOList.get(key);
            List<InvLotRpcDTO> invLotRpcDTOS = InvLotConvert.INSTANCE.voToRpcList(invLotRespVOS);
            result.put(key, invLotRpcDTOS);
        }
        return result;
    }
}