package com.elitesland.yst.production.inv.provider;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.Application;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvTrnDService;
import com.elitesland.yst.production.inv.application.service.InvTrnService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.domain.convert.InvTrnConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrn;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrnD;
import com.elitesland.yst.production.inv.domain.service.InvTrnDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invTrn.InvTrnResultRpcDTO;
import com.elitesland.yst.production.inv.dto.invTrn.InvTrnSaveRpcDTO;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.ValidationUtil;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.google.common.util.concurrent.AtomicDouble;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


@Service
@RequiredArgsConstructor

@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + InvTrnProvider.PATH)
public class InvTrnProviderImpl implements InvTrnProvider {

    private final InvTrnDomainService invTrnDomainService;

    private final InvTrnDDomainService invTrnDDomainService;

    private final InvWhDomainService invWhDomainService;

    private final SystemService systemService;

    private final InvWhAreaService invWhAreaService;

    private final InvTrnDService invTrnDService;

    private final InvTrnService invTrnService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<InvTrnResultRpcDTO> submitInvTrn(InvTrnSaveRpcDTO invTrnSaveRpcDTO) {
        log.info("库存转移生单开始：{}", JSON.toJSONString(invTrnSaveRpcDTO));
        try {
            this.saveCheckIn(invTrnSaveRpcDTO);
            List<InvTrnSaveRpcDTO.InvTrnDetail> details = invTrnSaveRpcDTO.getDetails();
            InvTrn invTrn = InvTrnConvert.INSTANCE.saveRpcDTOToInvTrn(invTrnSaveRpcDTO);
            invTrn.setDocStatus(UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
            invTrn.setProcInstStatus(ProcInstStatus.APPROVING);
            invTrn.setSubmitTime(LocalDateTime.now());
            invTrn.setApprTime(LocalDateTime.now());
            invTrn.setApplyDate(LocalDateTime.now());
            invTrn.setOuCode(invTrnSaveRpcDTO.getOOuCode());
            invTrn.setOuId(invTrnSaveRpcDTO.getOOuId());
            InvWhRespVO invWhRespVO = invWhDomainService.findByWhId(invTrnSaveRpcDTO.getOWhId());
            if(invWhRespVO == null){
                throw new BusinessException(ApiCode.FAIL,"仓库不存在，请检查");
            }
            invTrn.setSecBuId(invWhRespVO.getSecBuId());
            invTrn.setSecOuId(invTrnSaveRpcDTO.getOOuId());
            ArrayList<String> runtimeValues = new ArrayList<>();
            runtimeValues.add(invTrnSaveRpcDTO.getOOuCode());
            val code = systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IT.getCode(), runtimeValues);
            invTrn.setDocNo(code);
            Long id = invTrnDomainService.create(invTrn);
            AtomicDouble linoNo = new AtomicDouble(0);
            List<InvTrnD> invTrnDS = details.stream().map(d -> {
                InvTrnD invTrnD = new InvTrnD();
                BeanCopyUtil.beanCopyWithIngore(d, invTrnD, BeanCopyUtil.getNullPropertyNames(d));
                invTrnD.setMasId(id);
                invTrnD.setLineNo(linoNo.addAndGet(1));
                return invTrnD;
            }).collect(Collectors.toList());
            invTrnDDomainService.createBatch(invTrnDS);
            InvTrnResultRpcDTO resultRpcDTO = new InvTrnResultRpcDTO();
            resultRpcDTO.setDocNo(invTrn.getDocNo());
            resultRpcDTO.setId(id);
            return ApiResult.ok(resultRpcDTO);
        } catch (Exception e){
            throw new BusinessException(ApiCode.FAIL,"操作失败:"+e.getMessage());
        }

    }


    private void saveCheckIn(InvTrnSaveRpcDTO invTrnSaveVO){
        if(CollectionUtils.isEmpty(invTrnSaveVO.getDetails())){
            throw new BusinessException(ApiCode.FAIL,"参数错误，明细不能为空");
        }
        // 必填参数校验
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(invTrnSaveVO);
        if (validResult.isError()) {
            throw new BusinessException("主数据参数错误，移库原因、申请日期、从仓库、至仓库、从功能库区、至功能库区不能为空");
        }
        ValidationUtil.ValidResult validResult2 = ValidationUtil.validate(invTrnSaveVO.getDetails());
        if (validResult2.isError()) {
            throw new BusinessException("明细数据参数错误，从功能库区、至功能库区、转移数量、从仓库、至仓库 不能为空");
        }
        //仓库公司校验
        if(!invTrnSaveVO.getOOuId().toString().equals(invTrnSaveVO.getIOuId().toString())){
            throw new BusinessException("移入和移出仓库公司非同一公司请检查！");
        }
        //仓库在途功能区校验
        val whAreaList = invWhAreaService.findAllByWhId(invTrnSaveVO.getDetails().stream().map(InvTrnSaveRpcDTO.InvTrnDetail::getOWhId).collect(Collectors.toList()));
        long count = whAreaList.stream().filter(v -> UdcEnum.INV_FUNC_TYPE_9.getValueCode().equals(v.getDeter2())).distinct().count();
        if(count <1){
            throw new BusinessException("从仓库"+ invTrnSaveVO.getOWhCode()+"没有默认在途功能区，请检查！");
        }
        //明细行校验
        long count2 = invTrnSaveVO.getDetails().stream().map(v -> v.getItemId()+v.getOWhId()+"_" + v.getODeter2()+v.getIWhId()+"_"+v.getIDeter2()+"_"
                + v.getIPCode() + "_" + v.getIPType() + "_"
                + v.getOPCode() + "_" +v.getOPType()).distinct().count();
        if(count2 != invTrnSaveVO.getDetails().size()){
            throw new BusinessException("明细数据参数错误，商品ID,从仓库/从功能区,至功能区/至功能库区存在相同数据，请检查");
        }
        List<Long> owhIds = invTrnSaveVO.getDetails().stream().map(InvTrnSaveRpcDTO.InvTrnDetail::getOWhId).collect(Collectors.toList());
        List<Long> iwhIds = invTrnSaveVO.getDetails().stream().map(InvTrnSaveRpcDTO.InvTrnDetail::getIWhId).collect(Collectors.toList());
        InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
        areaParamVO.setWhIds(owhIds);
        List<InvWhAreaRespVO> whAreasByParam1 = invWhAreaService.findWhAreasByParam(areaParamVO);
        areaParamVO.setWhIds(iwhIds);
        List<InvWhAreaRespVO> whAreasByParam2 = invWhAreaService.findWhAreasByParam(areaParamVO);
        invTrnSaveVO.getDetails().stream().forEach(d ->{
            //校验仓库个人仓逻辑
            if(d.getOPCode() != null && d.getOPType() != null){
                List<InvWhAreaRespVO> whAreaRespVOS = whAreasByParam1.stream().filter(v -> d.getOPType().equals(v.getPType()) && d.getOPCode().equals(v.getPCode())).collect(Collectors.toList());
                if(CollectionUtils.isEmpty(whAreaRespVOS)){
                    throw new BusinessException(String.format("从仓库【%s】功能区【%s】合作伙伴【%s】不存在，请检查！",d.getOWhCode(),d.getODeter2(),d.getOPName()));
                }
            }
            if(d.getIPCode() != null && d.getIPType() != null){
                List<InvWhAreaRespVO> whAreaRespVOS = whAreasByParam2.stream().filter(v -> d.getIPType().equals(v.getPType()) && d.getIPCode().equals(v.getPCode())).collect(Collectors.toList());
                if(CollectionUtils.isEmpty(whAreaRespVOS)){
                    throw new BusinessException(String.format("至仓库【%s】功能区【%s】合作伙伴[%s]不存在，请检查！",d.getIWhCode(),d.getIDeter2(),d.getIPName()));
                }
            }
        });
    }


    @Override
    public Long checkInvTrn(Long masId) {
        log.info("库存转移审核开始：{}", masId);
        try {
            Long id = invTrnService.check(masId);
            return id;
        } catch (Exception e){
            throw new BusinessException(ApiCode.FAIL,"审核异常："+e.getMessage());
        }

    }

    @Override
    public Long confirmInvTrn(Long masId) {
        log.info("库存转移移库确认开始：{}", masId);
        try {
            invTrnDService.confirm(masId);
            return masId;
        } catch (Exception e){
            throw new BusinessException(ApiCode.FAIL,"收货确认异常："+e.getMessage());
        }
    }

    @Override
    public Long recvConfirmInvTrn(Long masId) {
        log.info("库存转移收货确认开始：{}", masId);
        try {
            invTrnDService.recevieConfirm(masId, false);
            return masId;
        } catch (Exception e){
            throw new BusinessException(ApiCode.FAIL,"移库确认异常："+e.getMessage());
        }
    }

}
