package com.elitesland.yst.production.inv.spi.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.domain.entity.QInvAjDO;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.spi.InvAjSpi;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.vo.InvAjVO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 03月 01日 4:25 下午
 * @version: 1.0
 */
@Slf4j
public class InvAjSpiImpl implements InvAjSpi {

    private WorkflowService workflowService;

    private JPAQueryFactory jpaQueryFactory;


    @Override
    public Boolean submitAjCallBack(WorkflowService workflowService, JPAQueryFactory jpaQueryFactory,Long id, InvAjVO invAjDTO) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.workflowService = workflowService;
        if (id == null
                || invAjDTO.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(invAjDTO.getProcInstStatus())
        ) {
            /**根据原因码，公司类型不同开启不同的工作流*/
            //流程判断
            String procInstName = "库存调整:" + invAjDTO.getDocNo();
            String procDefKeyName = ProcDefKey.INV_ADJST.name();
            this.startFile(procDefKeyName, invAjDTO, procInstName);
        }
        return true;
    }

    public void startFile(String procDefKeyName, InvAjVO invAjDTO, String procInstName) {
        /************************************************************************
         *                              工作流开始                              *
         ************************************************************************/
        //获取流程变量
        WorkflowResult<ProcessInfo> processInfoWorkflowResult = workflowService.startProcess(StartProcessPayload.of(procDefKeyName, procInstName, invAjDTO.getId() + "", null));
        if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
            throw new BusinessException("调用工作流异常，错误信息:" + processInfoWorkflowResult.getMsg());
        }
        //修改业务审批数据
        QInvAjDO qInvAjDO = QInvAjDO.invAjDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInvAjDO)
                .set(qInvAjDO.procInstId, processInfoWorkflowResult.getData().getProcInstId())
                .set(qInvAjDO.submitTime, LocalDateTime.now())
                .where(qInvAjDO.id.eq(invAjDTO.getId()));
        if (!Objects.equals(processInfoWorkflowResult.getData().getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qInvAjDO.procInstStatus, ProcInstStatus.APPROVING);
            jpaUpdateClause.set(qInvAjDO.docStatus, UdcEnum.PUR_PO_STATUS_APPING.getValueCode());//单据状态
        }
        jpaUpdateClause.execute();

        /************************************************************************
         *                              工作流结束                                *
         ************************************************************************/
    }
}
