/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.out;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.inv.application.out.PurDubbleService;
import com.elitesland.yst.production.pur.dto.ss.PurSsDTO;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.yst.production.pur.provider.PurSsProvider;
import com.elitesland.yst.production.pur.provider.PurSuppProvider;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurDubbleServiceImpl
implements PurDubbleService {
    private static final Logger log = LoggerFactory.getLogger(PurDubbleServiceImpl.class);
    private final PurSuppProvider purSuppProvider;
    private final PurSsProvider purSsProvider;

    @Override
    public List<PurSuppBaseRpcDTO> findBaseRpcDtoByParam(PurSuppBaseRpcParam param) {
        log.info("\u6839\u636efindBaseRpcDtoByParam\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)param);
        if (Objects.isNull(param)) {
            return Collections.EMPTY_LIST;
        }
        try {
            ApiResult apiResult = this.purSuppProvider.findBaseRpcDtoByParam(param);
            log.info("\u6839\u636efindBaseRpcDtoByParam\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess() && !com.alibaba.excel.util.CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
                return (List)apiResult.getData();
            }
        }
        catch (Exception e) {
            log.error("findBaseRpcDtoByParam error:", (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<PurSuppBaseRpcDTO> findSuppByIdBatch(List<Long> suppIds) {
        if (CollectionUtils.isEmpty(suppIds)) {
            return Lists.newArrayList();
        }
        try {
            PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
            purSuppBaseRpcParam.setSuppIds(suppIds);
            ApiResult apiResult = this.purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam);
            if (apiResult.isSuccess() && !com.alibaba.excel.util.CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
                return (List)apiResult.getData();
            }
        }
        catch (Exception e) {
            log.error("findSuppByIdBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<PurSuppBaseRpcDTO> findSuppByCode(String code) {
        log.info("\u6839\u636e\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)code);
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Optional.empty();
        }
        try {
            PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
            purSuppBaseRpcParam.setSuppCodes(Collections.singletonList(code));
            ApiResult apiResult = this.purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam);
            if (apiResult.isSuccess() && !com.alibaba.excel.util.CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
                PurSuppBaseRpcDTO purSuppBaseDTO = (PurSuppBaseRpcDTO)((List)apiResult.getData()).get(0);
                return Optional.of(purSuppBaseDTO);
            }
        }
        catch (Exception e) {
            log.error("findSuppByCode error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<PurSuppBaseRpcDTO> findSuppByCodeBatch(List<String> codes) {
        log.info("\u6839\u636e\u4f9b\u5e94\u5546\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u4f9b\u5e94\u5546\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), codes);
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.EMPTY_LIST;
        }
        try {
            PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
            purSuppBaseRpcParam.setSuppCodes(codes);
            ApiResult apiResult = this.purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam);
            if (apiResult.isSuccess() && !com.alibaba.excel.util.CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
                return (List)apiResult.getData();
            }
        }
        catch (Exception e) {
            log.error("findSuppByCodeBatch error:", (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void updateCarrierInfo(PurSsDTO param) {
        ApiResult apiResult = this.purSsProvider.updateCarrierInfo(param);
        Assert.isTrue((boolean)apiResult.isSuccess(), (String)"\u66f4\u65b0\u4f9b\u5e94\u5546\u53d1\u8d27\u5355\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
    }

    @Override
    public void updateIsCarrige(PurSsDTO param) {
        ApiResult apiResult = this.purSsProvider.updateIsCarrige(param);
        Assert.isTrue((boolean)apiResult.isSuccess(), (String)"\u66f4\u65b0\u4f9b\u5e94\u5546\u53d1\u8d27\u5355\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
    }

    public PurDubbleServiceImpl(PurSuppProvider purSuppProvider, PurSsProvider purSsProvider) {
        this.purSuppProvider = purSuppProvider;
        this.purSsProvider = purSsProvider;
    }
}

