/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAllQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAndAsmDDownloadRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAndAsmDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvCalCostQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon28InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon37InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAsmDService;
import com.elitesland.yst.production.inv.application.service.InvAsmService;
import com.elitesland.yst.production.inv.application.service.InvStkCommonService;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.InvAsmAndAsmDConvert;
import com.elitesland.yst.production.inv.domain.convert.InvAsmDConvert;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvCommonConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDO;
import com.elitesland.yst.production.inv.domain.service.InvAsmDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.enums.InvStkSceneCodeEnum;
import com.elitesland.yst.production.inv.infr.dto.InvAsmAndAsmDDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepoProc;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepo;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.collections4.MapUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvAsmDServiceImpl
implements InvAsmDService {
    private final InvAsmRepo invAsmRepo;
    private final InvAsmDRepo invAsmDRepo;
    private final InvAsmDRepoProc invAsmDRepoProc;
    private final InvStkCommonService invStkCommonService;
    private final InvStkService invStkService;
    private final InvAsmService invAsmService;
    private final InvWhDomainService invWhService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;
    private final OrgOutService outouService;
    private final InvAsmDDomainService invAsmDDomainService;
    private final InvStkOptBizService invStkOptBizService;
    private final InvWhAreaDomainService invWhAreaDomainService;

    @Override
    @SysCodeProc
    public PagingVO<InvAsmAndAsmDRespVO> search(InvAsmAllQueryParam param) {
        PagingVO<InvAsmAndAsmDDTO> pagingVO = this.invAsmDDomainService.search(param);
        List invAsmAndAsmDDTOS = pagingVO.getRecords();
        List<InvAsmAndAsmDRespVO> asmDRespVOS = invAsmAndAsmDDTOS.stream().map(InvAsmDConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
        this.fillupNameList(asmDRespVOS);
        List<InvAsmAndAsmDRespVO> invAsmAndAsmDRespVOS = this.udcChange(asmDRespVOS);
        return PagingVO.builder().total(pagingVO.getTotal()).records(invAsmAndAsmDRespVOS).build();
    }

    @Override
    @SysCodeProc
    public PagingVO<InvAsmAndAsmDRespVO> searchD(InvAsmAllQueryParam param) {
        PagingVO<InvAsmAndAsmDDTO> pagingVO = this.invAsmDDomainService.search(param);
        List asmAndAsmDDTOS = pagingVO.getRecords();
        List<InvAsmAndAsmDRespVO> asmDRespVOS = asmAndAsmDDTOS.stream().map(InvAsmDConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
        this.fillupNameList(asmDRespVOS);
        List<InvAsmAndAsmDRespVO> invAsmAndAsmDRespVOS = this.udcChange(asmDRespVOS);
        return PagingVO.builder().total(pagingVO.getTotal()).records(invAsmAndAsmDRespVOS).build();
    }

    @Override
    @SysCodeProc
    public List<InvAsmDRespVO> listByCostCal(InvCalCostQueryParam param, int current, int PAGE_SIZE) {
        PageRequest pageable = PageRequest.of((int)(current - 1), (int)PAGE_SIZE);
        Page<InvAsmDDO> invAsms = this.invAsmDRepoProc.listByCostCal(param, (Pageable)pageable);
        return invAsms.stream().map(InvAsmDConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<InvAsmAndAsmDRespVO> findAll(InvAsmAllQueryParam param) {
        List<InvAsmAndAsmDDTO> asmAndAsmDDTOS = this.invAsmDDomainService.findAll(param);
        List<InvAsmAndAsmDRespVO> asmDRespVOS = asmAndAsmDDTOS.stream().map(InvAsmDConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
        this.fillupNameList(asmDRespVOS);
        List<InvAsmAndAsmDRespVO> invAsmAndAsmDRespVOS = this.udcChange(asmDRespVOS);
        return invAsmAndAsmDRespVOS;
    }

    public List<InvAsmAndAsmDRespVO> udcChange(List<InvAsmAndAsmDRespVO> asms) {
        Map<String, String> udcDocType = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_ASM_TYPE_DEF.getModel(), UdcEnum.INV_ASM_TYPE_DEF.getCode());
        Map<String, String> udcDocStatus = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_ASM_STATUS_DR.getModel(), UdcEnum.INV_ASM_STATUS_DR.getCode());
        Map<String, String> udcApprStatus = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_APPR_STATUS_APPROVING.getModel(), UdcEnum.COM_APPR_STATUS_APPROVING.getCode());
        Map<String, String> udcIO = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_IO_I.getModel(), UdcEnum.COM_IO_I.getCode());
        Map<String, String> udcDeter1 = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());
        Map<String, String> udcReasonCode = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());
        Map<String, String> udcUom = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        asms.stream().forEach(Asm -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getDocType()) && !MapUtils.isEmpty((Map)udcDocType)) {
                Asm.setDocTypeName((String)udcDocType.get(Asm.getDocType()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getDocStatus()) && !MapUtils.isEmpty((Map)udcDocStatus)) {
                Asm.setDocStatusName((String)udcDocStatus.get(Asm.getDocStatus()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getApprStatus()) && !MapUtils.isEmpty((Map)udcApprStatus)) {
                Asm.setApprStatusName((String)udcApprStatus.get(Asm.getApprStatus()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getDeter1()) && !MapUtils.isEmpty((Map)udcDeter1)) {
                Asm.setDeter1Name((String)udcDeter1.get(Asm.getDeter1()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getReasonCode()) && !MapUtils.isEmpty((Map)udcReasonCode)) {
                Asm.setReasonCodeName((String)udcReasonCode.get(Asm.getReasonCode()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getUom()) && !MapUtils.isEmpty((Map)udcUom)) {
                Asm.setUomName((String)udcUom.get(Asm.getUom()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Asm.getLineType()) && !MapUtils.isEmpty((Map)udcIO)) {
                Asm.setLineTypeName((String)udcIO.get(Asm.getLineType()));
            }
        });
        return asms;
    }

    @Override
    @Transactional
    public int removeInBatch(List<Long> ids) {
        ids.forEach(id -> this.invAsmDRepo.deleteById(id));
        return ids.size();
    }

    public void useInvStkCommon37InVOS(List<InvAsmDDO> invAsmDDOS, InvAsmDO invAsmDO) {
        ArrayList<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS = new ArrayList<InvStkCommon37InSaveVO>();
        invAsmDDOS.stream().forEach(v -> {
            if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                InvStkCommon37InSaveVO tmp = InvCommonConvert.INSTANCE.invAsmDDOToInvStkCommon37InVO((InvAsmDDO)v);
                tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_27);
                tmp.setDeter1(invAsmDO.getDeter1());
                tmp.setDeter2(invAsmDO.getDeter2());
                tmp.setDeter3(invAsmDO.getDeter3());
                tmp.setWhId(invAsmDO.getWhId());
                tmp.setDocNo(invAsmDO.getDocNo());
                tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
                tmp.setSrcDocId(v.getMasId());
                tmp.setSrcDocDid(v.getId());
                tmp.setOpDate(LocalDateTime.now());
                invStkCommon37InSaveVOS.add(tmp);
            }
        });
        if (!CollectionUtils.isEmpty(invStkCommon37InSaveVOS)) {
            this.invStkCommonService.invStkCommon37(invStkCommon37InSaveVOS);
        }
    }

    public void useInvStkCommon28(Long masId) {
        InvAsmAllQueryParam param = new InvAsmAllQueryParam();
        param.setMasId(masId);
        this.invStkCommonService.invStkCommon28(this.findAll(param).stream().map(v -> {
            InvStkCommon28InSaveVO tmp = InvCommonConvert.INSTANCE.invAsmDVOAndInvAsmVOToInvStkCommon28InRespVO((InvAsmAndAsmDRespVO)v);
            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            if (v.getLineType().equals(UdcEnum.COM_IO_I.getValueCode())) {
                tmp.setInvStk28Enum1(InvStk28Enum.I_TYPE_18);
            } else if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                tmp.setInvStk28Enum1(InvStk28Enum.O_TYPE_19);
            }
            tmp.setOpDate(LocalDateTime.now());
            return tmp;
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional
    public void confirm(Long masId) {
        InvAsmDO invAsmDO = (InvAsmDO)this.invAsmRepo.findById(masId).orElseThrow(new BusinessException("\u6570\u636e\u9519\u8bef"));
        List<InvAsmDDO> invAsmDDOS = this.invAsmDRepo.findByMasId(masId);
        this.invAsmService.updateStatusInBatch(List.of(masId), UdcEnum.INV_ASM_STATUS_CF.getValueCode());
        List<InvAsmDDO> invAsmDDOOList = invAsmDDOS.stream().filter(v -> v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())).collect(Collectors.toList());
        List<InvAsmDDO> invAsmDDOIList = invAsmDDOS.stream().filter(v -> v.getLineType().equals(UdcEnum.COM_IO_I.getValueCode())).collect(Collectors.toList());
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        operateDTO.setSceneCode(InvStkSceneCodeEnum.INV_ASM_ASM002.getType());
        operateDTO.setSource("YST-INV");
        if (!CollectionUtils.isEmpty(invAsmDDOOList)) {
            List<InvStkCommonOperateBodyDTO> operateBodyList1 = this.getOperateBodyList(invAsmDDOOList, invAsmDO);
            operateDTO.setSourceBodyList(operateBodyList1);
        }
        if (!CollectionUtils.isEmpty(invAsmDDOIList)) {
            List<InvStkCommonOperateBodyDTO> operateBodyList2 = this.getOperateBodyList(invAsmDDOIList, invAsmDO);
            operateDTO.setTargetBodyList(operateBodyList2);
        }
        this.invStkOptBizService.invStkCommonOperate(operateDTO);
    }

    private List<InvStkCommonOperateBodyDTO> getOperateBodyList(List<InvAsmDDO> invAsmDDOS, InvAsmDO invAsmDO) {
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<InvStkCommonOperateBodyDTO>();
        invAsmDDOS.stream().forEach(invAsmDDO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAsmDO.getWhId());
            operateBodyDTO.setItemId(invAsmDDO.getItemId());
            operateBodyDTO.setDeter2(invAsmDO.getDeter2());
            operateBodyDTO.setSrcDocId(invAsmDO.getId());
            operateBodyDTO.setDocNo(invAsmDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAsmDDO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            operateBodyDTO.setLineNo(invAsmDDO.getLineNo());
            operateBodyDTO.setCreateUserId(invAsmDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAsmDDO.getUom());
            operateBodyDTO.setQty(invAsmDDO.getQty());
            operateBodyDTO.setLotNo(invAsmDDO.getLotNo());
            operateBodyDTO.setOuId(invAsmDO.getOuId());
            operateBodyDTO.setVariId(invAsmDDO.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        return operateBodyDTOS;
    }

    @Override
    @Transactional
    public void check(Long masId) {
        Optional invAsmDOOptional = this.invAsmRepo.findById(masId);
        if (invAsmDOOptional.isPresent()) {
            if (((InvAsmDO)invAsmDOOptional.get()).getProcInstId() != null) {
                throw new BusinessException(ApiCode.FAIL, "\u8be5\u5355\u636e\u5df2\u5f00\u542f\u5de5\u4f5c\u6d41\u5ba1\u6279");
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        ((InvAsmDO)invAsmDOOptional.get()).setDocStatus(UdcEnum.INV_ASM_STATUS_APPED.getValueCode());
        this.invAsmRepo.save((InvAsmDO)invAsmDOOptional.get());
    }

    @Override
    @Transactional
    public void refuse(Long masId) {
        Optional invAsmDOOptional = this.invAsmRepo.findById(masId);
        if (invAsmDOOptional.isPresent()) {
            if (((InvAsmDO)invAsmDOOptional.get()).getProcInstId() != null) {
                throw new BusinessException(ApiCode.FAIL, "\u8be5\u5355\u636e\u5df2\u5f00\u542f\u5de5\u4f5c\u6d41\u5ba1\u6279");
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + masId);
        }
        ((InvAsmDO)invAsmDOOptional.get()).setDocStatus(UdcEnum.INV_ASM_STATUS_RJ.getValueCode());
        this.invAsmRepo.save((InvAsmDO)invAsmDOOptional.get());
        this.releasLockQty(masId);
    }

    @Override
    public List<InvAsmAndAsmDDownloadRespVO> outerNoAndOuterType(List<InvAsmAndAsmDRespVO> list) {
        List<InvAsmAndAsmDDownloadRespVO> collect = list.stream().map(i -> {
            InvAsmAndAsmDDownloadRespVO downloadVO = InvAsmAndAsmDConvert.INSTANCE.respVOTODownloadRespVO((InvAsmAndAsmDRespVO)i);
            return downloadVO;
        }).collect(Collectors.toList());
        return collect;
    }

    public void releasLockQty(Long masId) {
        Optional invAsmDOOptional = this.invAsmRepo.findById(masId);
        ArrayList<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS = new ArrayList<InvStkCommon37InSaveVO>();
        List<InvAsmDDO> invAsmDDOS = this.invAsmDRepo.findByMasId(masId);
        invAsmDDOS.stream().forEach(v -> {
            if (v.getLineType().equals(UdcEnum.COM_IO_O.getValueCode())) {
                InvStkCommon37InSaveVO tmp = InvCommonConvert.INSTANCE.invAsmDDOToInvStkCommon37InVO((InvAsmDDO)v);
                tmp.setInvStk28Enum1(InvStk28Enum.T_TYPE_27);
                if (invAsmDOOptional.isPresent()) {
                    tmp.setDeter1(((InvAsmDO)invAsmDOOptional.get()).getDeter1());
                    tmp.setDeter2(((InvAsmDO)invAsmDOOptional.get()).getDeter2());
                    tmp.setDeter3(((InvAsmDO)invAsmDOOptional.get()).getDeter3());
                    tmp.setWhId(((InvAsmDO)invAsmDOOptional.get()).getWhId());
                    tmp.setDocNo(((InvAsmDO)invAsmDOOptional.get()).getDocNo());
                    tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
                    tmp.setSrcDocId(v.getMasId());
                    tmp.setSrcDocDid(v.getId());
                    tmp.setOpDate(LocalDateTime.now());
                }
                invStkCommon37InSaveVOS.add(tmp);
            }
        });
        this.invStkCommonService.invStkCommon37(invStkCommon37InSaveVOS);
    }

    public List<InvAsmAndAsmDRespVO> fillupNameList(List<InvAsmAndAsmDRespVO> items) {
        List<Long> empIds = items.stream().map(InvAsmAndAsmDRespVO::getApplyEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> sysUserDOS = this.systemService.findAllEmpsByIdIn(empIds);
        List deter2s = items.stream().map(InvAsmAndAsmDRespVO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List whIds = items.stream().map(InvAsmAndAsmDRespVO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List itemIds = items.stream().map(InvAsmAndAsmDRespVO::getItemId).collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemPartDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        items.forEach(a -> {
            OrgEmpRpcDTO empRpcDTO;
            Optional<InvWhRespVO> orgWh;
            OrgOuRpcDTO orgOu;
            if (!CollectionUtils.isEmpty((Collection)sysUserDOS)) {
                sysUserDOS.stream().filter(emp -> emp.getId().equals(a.getApplyEmpId())).findAny().ifPresent(m -> a.setApplyEmpIdName(m.getUsername()));
            }
            if (!StringUtils.isEmpty((Object)a.getItemId()) && !CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                itmItemPartDTOS.stream().filter(v -> v.getId().equals(a.getItemId())).findFirst().ifPresent(m -> {
                    a.setItemCode(m.getItemCode());
                    a.setItemName(m.getItemName());
                    a.setPackageSpec(m.getPackageSpec());
                    a.setItemSpec(m.getSpec());
                    a.setBrand(m.getBrand());
                    a.setLotFlag(m.getLotFlag());
                    a.setBrandName(m.getBrandName());
                    a.setStoreExpireDays(m.getGuaranteeDays());
                });
            }
            if (!StringUtils.isEmpty((Object)(orgOu = this.outouService.findOuById(a.getOuId() == null ? 0L : a.getOuId())))) {
                a.setOuName(orgOu.getOuName());
                a.setOuCode(orgOu.getOuCode());
                a.setCurrCode(orgOu.getOuCurr());
            }
            if ((orgWh = this.invWhService.findById(a.getWhId() == null ? 0L : a.getWhId())).isPresent()) {
                a.setWhCode(orgWh.get().getWhCode());
                a.setWhName(orgWh.get().getWhName());
            }
            InvBaseModel invStkParam = new InvBaseModel();
            invStkParam.setItemId(a.getItemId());
            invStkParam.setWhId(a.getWhId());
            invStkParam.setVariId(a.getVariId());
            invStkParam.setLotNo(a.getLotNo());
            invStkParam.setDeter1(a.getDeter1());
            invStkParam.setDeter2(a.getDeter2());
            InvStkRespVO invStk = this.invStkService.getInvStk(invStkParam);
            if (invStk != null) {
                a.setAvalQty(invStk.getAvalQty());
            }
            if (!StringUtils.isEmpty((Object)a.getApplyEmpId()) && (empRpcDTO = this.outouService.findEmpById(a.getApplyEmpId())) != null) {
                a.setApplyEmpIdName(empRpcDTO.getEmpName());
            }
        });
        List<String> ouCurrList = items.stream().map(InvAsmAndAsmDRespVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(ouCurrList)) {
            List<SysCurrencyRespDTO> comCurrRpcDTOS = this.outouService.findRpcDtoByParam(ouCurrList);
            Map<String, String> stringMap = comCurrRpcDTOS.stream().collect(Collectors.toMap(SysCurrencyRespDTO::getCurrCode, SysCurrencyRespDTO::getCurrName));
            if (!CollectionUtils.isEmpty(comCurrRpcDTOS)) {
                items.stream().forEach(v -> {
                    if (v.getCurrCode() != null) {
                        v.setCurrCodeName((String)stringMap.get(v.getCurrCode()));
                    }
                });
            }
        }
        return items;
    }

    public InvAsmDServiceImpl(InvAsmRepo invAsmRepo, InvAsmDRepo invAsmDRepo, InvAsmDRepoProc invAsmDRepoProc, InvStkCommonService invStkCommonService, InvStkService invStkService, InvAsmService invAsmService, InvWhDomainService invWhService, SystemService systemService, ItmOutService itmOutService, OrgOutService outouService, InvAsmDDomainService invAsmDDomainService, InvStkOptBizService invStkOptBizService, InvWhAreaDomainService invWhAreaDomainService) {
        this.invAsmRepo = invAsmRepo;
        this.invAsmDRepo = invAsmDRepo;
        this.invAsmDRepoProc = invAsmDRepoProc;
        this.invStkCommonService = invStkCommonService;
        this.invStkService = invStkService;
        this.invAsmService = invAsmService;
        this.invWhService = invWhService;
        this.systemService = systemService;
        this.itmOutService = itmOutService;
        this.outouService = outouService;
        this.invAsmDDomainService = invAsmDDomainService;
        this.invStkOptBizService = invStkOptBizService;
        this.invWhAreaDomainService = invWhAreaDomainService;
    }
}

