/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliveryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliveryRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliverySaveVO;
import com.elitesland.yst.production.inv.application.service.InvWhDeliveryService;
import com.elitesland.yst.production.inv.domain.convert.invwh.InvWhDeliveryConvert;
import com.elitesland.yst.production.inv.domain.service.InvWhDeliveryDomainService;
import com.elitesland.yst.production.inv.infr.repo.InvWhDeliveryRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhDeliveryProc;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="invWhDeliveryService")
public class InvWhDeliveryServiceImpl
implements InvWhDeliveryService {
    private final InvWhDeliveryRepo invWhDeliveryRepo;
    private final InvWhDeliveryProc invWhDeliveryProc;
    private final InvWhDeliveryDomainService invWhDeliveryDomainService;

    @Override
    public Optional<InvWhDeliveryRespVO> findIdOne(Long id) {
        InvWhDeliveryParamVO param = new InvWhDeliveryParamVO();
        param.setId(id);
        List<InvWhDeliveryRespVO> vos = this.invWhDeliveryProc.select(param);
        if (!CollectionUtils.isEmpty(vos)) {
            return Optional.ofNullable(vos.get(0));
        }
        return Optional.empty();
    }

    @Override
    public PagingVO<InvWhDeliveryRespVO> search(InvWhDeliveryParamVO param) {
        PagingVO<InvWhDeliveryRespVO> pagingResult = this.invWhDeliveryProc.selectDeliveryPagingResult(param);
        return pagingResult;
    }

    @Override
    public List<InvWhDeliveryRespVO> findByWhId(Long whId) {
        InvWhDeliveryParamVO param = new InvWhDeliveryParamVO();
        param.setWhId(whId);
        List<InvWhDeliveryRespVO> respVOS = this.invWhDeliveryProc.select(param);
        return respVOS;
    }

    @Override
    @Transactional
    public Long createOne(InvWhDeliverySaveVO objVo) {
        return this.invWhDeliveryDomainService.saveInvWhDelivery(InvWhDeliveryConvert.INSTANCE.voToDO(objVo)).getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<InvWhDeliverySaveVO> list) {
        return this.invWhDeliveryDomainService.saveInvWhDeliveries(list.stream().map(InvWhDeliveryConvert.INSTANCE::voToDO).collect(Collectors.toList())).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public InvWhDeliveryServiceImpl(InvWhDeliveryRepo invWhDeliveryRepo, InvWhDeliveryProc invWhDeliveryProc, InvWhDeliveryDomainService invWhDeliveryDomainService) {
        this.invWhDeliveryRepo = invWhDeliveryRepo;
        this.invWhDeliveryProc = invWhDeliveryProc;
        this.invWhDeliveryDomainService = invWhDeliveryDomainService;
    }
}

