/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.provider;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkDQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkGroupRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkItemQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryGroupParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvUomQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.ItmInvStkItemRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.service.InvLotService;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.domain.service.InvStkDomainService;
import com.elitesland.yst.production.inv.dto.invstk.InvStkAllRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.InvStkDRpcDTO;
import com.elitesland.yst.production.inv.dto.invstk.InvStkDRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.InvStkGroupRpcDTO;
import com.elitesland.yst.production.inv.dto.invstk.InvStkItemRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.InvStkItemUomRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDTO;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.ItmInvStkItemRpcDTO;
import com.elitesland.yst.production.inv.provider.InvStkProvider;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.ValidationUtil;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.item.param.ItmItemUomConvRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/invStk"})
public class InvStkProviderImpl
implements InvStkProvider {
    private static final Logger log = LoggerFactory.getLogger(InvStkProviderImpl.class);
    @Autowired
    private InvStkDomainService invStkDomainService;
    @Autowired
    private ItmOutService itmOutService;
    @Autowired
    private OrgOutService orgOutService;
    @Autowired
    private InvWhService invWhService;
    @Autowired
    private InvWhAreaSettingService invWhAreaSettingService;
    @Autowired
    private InvLotService invLotService;
    @Autowired
    private InvStkService invStkService;

    public List<InvStkRpcDTO> findInvStkRpcDtoByParam(InvStkAllRpcDtoParam invStkAllRpcDtoParam) {
        log.info("\u6761\u4ef6\u67e5\u8be2\u5e93\u5b58\u65b9\u6cd5\u5f00\u59cb\uff1a\u65f6\u95f4\uff1a{},\u53c2\u6570:{}", (Object)LocalDateTime.now(), (Object)invStkAllRpcDtoParam);
        if (null != invStkAllRpcDtoParam.getMenuLotNo() && !"".equals(invStkAllRpcDtoParam.getMenuLotNo())) {
            List<String> lotNos = this.invLotService.findLotNoByManuLot(invStkAllRpcDtoParam.getMenuLotNo());
            invStkAllRpcDtoParam.setLotNos(lotNos);
        }
        List<InvStkRpcDTO> stkRpcDTOList = this.invStkDomainService.findStkAllRpcDTOByParam(invStkAllRpcDtoParam);
        List<InvStkRpcDTO> stkRpcDTOS = this.stkUomBatchConvertHandle(stkRpcDTOList, invStkAllRpcDtoParam.getInvStkItemUomParams());
        this.translate(stkRpcDTOS);
        return stkRpcDTOList;
    }

    public ApiResult<InvStkRpcDTO> getInvStk(InvStkRpcDtoParam param) {
        log.info("\u67e5\u8be2\u5e93\u5b58\u65b9\u6cd5\u5f00\u59cb\uff1a\u65f6\u95f4\uff1a{},\u53c2\u6570:{}", (Object)LocalDateTime.now(), (Object)param);
        this.validParam(param);
        List<InvStkRpcDTO> invStkRespVOs = this.invStkDomainService.getInvStkRpcDTOByParam(param);
        if (!CollectionUtils.isEmpty(invStkRespVOs)) {
            this.translate(invStkRespVOs);
            InvStkRpcDTO invStkDTO = invStkRespVOs.get(0);
            if (!invStkDTO.getUom().equals(param.getToUom())) {
                InvStkRpcDTO invStkRpcDTO = this.stkUomConvertHandle(invStkRespVOs, param.getToUom()).get(0);
                return ApiResult.ok((Object)invStkRpcDTO);
            }
            return ApiResult.ok((Object)invStkDTO);
        }
        return ApiResult.ok(null);
    }

    public List<ItmInvStkItemRpcDTO> getItemInvStk(InvStkItemRpcDtoParam param) {
        InvStkItemQueryParam queryParam = InvStkConvert.INSTANCE.stkItemRpcDtoParamToParam(param);
        List<ItmInvStkItemRespVO> stkItemRespVOS = this.invStkService.getInvStkItemByParam(queryParam);
        if (!CollectionUtils.isEmpty(stkItemRespVOS)) {
            return stkItemRespVOS.stream().map(InvStkConvert.INSTANCE::stkItemVoToDto).collect(Collectors.toList());
        }
        return new ArrayList<ItmInvStkItemRpcDTO>();
    }

    public PagingVO<InvStkGroupRpcDTO> searchPaging(InvStkAllRpcDtoParam param) {
        InvStkQueryGroupParamVO groupParamVO = InvStkConvert.INSTANCE.allRpcParamToParam(param);
        PagingVO<InvStkGroupRespVO> pagingVO = this.invStkService.searchD(groupParamVO);
        List ret = pagingVO.getRecords().stream().map(InvStkConvert.INSTANCE::stkRespVoToGroupRpcDto).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVO.getTotal()).records(ret).build();
    }

    public PagingVO<InvStkDRpcDTO> searchLotPaging(InvStkDRpcDtoParam param) {
        InvStkDQueryParamVO queryParam = InvStkConvert.INSTANCE.rpcDtoParamToParam(param);
        PagingVO<InvStkDRespVO> pagingVO = this.invStkService.searchLot(queryParam);
        List result = pagingVO.getRecords().stream().map(InvStkConvert.INSTANCE::respVoToRpcDto).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVO.getTotal()).records(result).build();
    }

    private List<InvStkRpcDTO> stkUomBatchConvertHandle(List<InvStkRpcDTO> stkRpcDTOList, List<InvStkItemUomRpcDtoParam> stkItemUomParams) {
        if (CollectionUtils.isEmpty(stkItemUomParams)) {
            return stkRpcDTOList;
        }
        List<Long> itemIds = stkItemUomParams.stream().map(InvStkItemUomRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        List<ItmItemUomConvRpcDTO> uomConvRpcDTOS = this.getUomConvRpcDTOS(itemIds);
        stkRpcDTOList.stream().forEach(v -> stkItemUomParams.stream().filter(i -> i.getItemId().equals(v.getItemId()) && !i.getToUom().equals(v.getUom())).findAny().ifPresent(invStkItemUomParam -> {
            InvUomQueryParamVO queryParamVO = new InvUomQueryParamVO();
            queryParamVO.setFromUom(v.getUom());
            queryParamVO.setToUom(invStkItemUomParam.getToUom());
            queryParamVO.setItemId(v.getItemId());
            queryParamVO.setItemCode(v.getItemCode());
            BigDecimal uomRatio = this.itmOutService.getUomRatio(uomConvRpcDTOS, queryParamVO);
            if (uomRatio.compareTo(BigDecimal.ZERO) > 0) {
                v.setAvalQty(v.getAvalQty().multiply(uomRatio));
            } else if (uomRatio.compareTo(BigDecimal.ZERO) < 0) {
                v.setAvalQty(this.calculateQty2(uomRatio, v.getAvalQty()));
            }
            v.setUom(invStkItemUomParam.getToUom());
            v.setUomRatio(uomRatio);
        }));
        return stkRpcDTOList;
    }

    private List<InvStkRpcDTO> stkUomConvertHandle(List<InvStkRpcDTO> stkRpcDTOList, String toUom) {
        List<Long> itemIds = stkRpcDTOList.stream().map(InvStkRpcDTO::getItemId).distinct().collect(Collectors.toList());
        List<ItmItemUomConvRpcDTO> uomConvRpcDTOS = this.getUomConvRpcDTOS(itemIds);
        stkRpcDTOList.stream().forEach(v -> {
            if (!v.getUom().equals(toUom)) {
                InvUomQueryParamVO queryParamVO = new InvUomQueryParamVO();
                queryParamVO.setFromUom(v.getUom());
                queryParamVO.setToUom(toUom);
                queryParamVO.setItemId(v.getItemId());
                queryParamVO.setItemCode(v.getItemCode());
                BigDecimal uomRatio = this.itmOutService.getUomRatio(uomConvRpcDTOS, queryParamVO);
                if (uomRatio.compareTo(BigDecimal.ZERO) > 0) {
                    v.setAvalQty(v.getAvalQty().multiply(uomRatio));
                } else if (uomRatio.compareTo(BigDecimal.ZERO) < 0) {
                    v.setAvalQty(this.calculateQty2(uomRatio, v.getAvalQty()));
                }
                v.setUom(toUom);
            }
        });
        return stkRpcDTOList;
    }

    private BigDecimal calculateQty2(BigDecimal uomRatio, BigDecimal qty) {
        return qty.divide(uomRatio.negate(), 2, RoundingMode.HALF_UP);
    }

    private List<ItmItemUomConvRpcDTO> getUomConvRpcDTOS(List<Long> itemIds) {
        ItmItemUomConvRpcDtoParam param = new ItmItemUomConvRpcDtoParam();
        param.setItemIds(itemIds);
        List<ItmItemUomConvRpcDTO> uomConvRpcDTOS = this.itmOutService.findItemUomConvDtoByParam(param);
        return uomConvRpcDTOS;
    }

    private void validParam(InvStkRpcDtoParam param) {
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(param);
        if (validResult.isError()) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1\u3001\u4ed3\u5e93\u3001\u529f\u80fd\u533a\u3001\u8f6c\u6362\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (param.getPType() != null && param.getPCode() == null) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef\uff0c\u5e93\u5b58\u5408\u4f5c\u4f19\u4f34\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (param.getPCode() != null && param.getPType() == null) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef\uff0c\u5e93\u5b58\u5408\u4f5c\u4f19\u4f34\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public void translate(List<InvStkRpcDTO> stkResults) {
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        List itemIds = stkResults.stream().map(InvStkRpcDTO::getItemId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemIds)) {
            itemIds = null;
        }
        itmItemPartParam.setItemIds(itemIds);
        List<OrgOuRpcDTO> orgOuResults = this.orgOutService.findOuByIds(stkResults.stream().map(InvStkRpcDTO::getOuId).collect(Collectors.toList()));
        List<ItmItemRpcDTO> itmItemResults = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<String> pcodes = stkResults.stream().filter(s -> UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(s.getPType())).map(InvStkRpcDTO::getPCode).collect(Collectors.toList());
        List<OrgRespVO> empList = this.orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_EMP, pcodes);
        stkResults.stream().forEach(i -> {
            if (!CollectionUtils.isEmpty((Collection)itmItemResults)) {
                itmItemResults.stream().filter(v -> v.getId().equals(i.getItemId())).findAny().ifPresent(m -> i.setItemCode(m.getItemCode()));
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuResults)) {
                orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId())).findAny().ifPresent(m -> {
                    i.setOuCode(m.getOuCode());
                    i.setOuName(m.getOuName());
                });
            }
            if (UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(i.getPType()) && !CollectionUtils.isEmpty((Collection)empList)) {
                empList.stream().filter(m -> m.getCode().equals(i.getPCode())).findAny().ifPresent(m -> i.setPName(m.getName()));
            }
        });
    }
}

