/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.out;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.support.provider.item.service.ItmItemRpcService;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SystemServiceImpl
implements SystemService {
    private static final Logger log = LoggerFactory.getLogger(SystemServiceImpl.class);
    private final SeqNumProvider sysNumberRuleService;
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final UdcProvider udcProvider;
    private final SysAreaRpcService sysAreaRpcService;
    private final ItmItemRpcService itemRpcService;
    private final SysUserRpcService sysUserService;
    private final SysSettingService sysSettingService;
    private final OrgRpcService orgRpcService;

    @Override
    public Map<String, String> sysUdcGetCodeMap(String domain, String udc) {
        try {
            Map codeMap = this.udcProvider.getValueMapByUdcCode(domain, udc);
            return codeMap;
        }
        catch (Exception e) {
            log.error("findCodeBatch error:", (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    @Override
    public String sysNumberRuleGenerateCode(String code, List<String> runtimeValues) {
        log.info("\u5e93\u5b58\u4e2d\u5fc3\u53d1\u53f7\u5668\u8c03\u7528\uff1a\u65f6\u95f4\uff1a{}\uff0c\u53c2\u6570{},{}", new Object[]{LocalDateTime.now(), code, runtimeValues});
        String sys = "";
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(runtimeValues);
        try {
            sys = this.sysNumberRuleService.generateCode("yst-inv", code, list);
        }
        catch (Exception e) {
            log.error("sysNumberRuleGenerateCode error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u53d1\u53f7\u5931\u8d25");
        }
        return sys;
    }

    @Override
    public List<SysUserVO> findAllEmpsByIdIn(List<Long> calcEmpIds) {
        try {
            if (calcEmpIds.isEmpty()) {
                return null;
            }
            List sysUserVOList = this.sysUserService.getByIds(calcEmpIds);
            if (!com.alibaba.excel.util.CollectionUtils.isEmpty((Collection)sysUserVOList)) {
                return sysUserVOList;
            }
        }
        catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Long> findUserIdsByFlowRoles(Long ouId, String customParams) {
        log.info("\u901a\u8fc7ouId,\u81ea\u5b9a\u4e49\u53c2\u6570\u83b7\u53d6\u7528\u6237\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)ouId);
        try {
            SysUserIdFlowRoleRpcParam param = new SysUserIdFlowRoleRpcParam();
            param.setOuIds(Collections.singletonList(ouId));
            param.setFlowRoleCodes(Collections.singletonList(customParams));
            List userIds = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
            if (!CollectionUtils.isEmpty((Collection)userIds)) {
                return userIds;
            }
        }
        catch (Exception e) {
            log.error("findUserIdsByFlowRoles error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        return null;
    }

    @Override
    public SysUserDTO sysUserCurrent() {
        try {
            GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
            if (userDetails == null) {
                return null;
            }
            SysUserDTO sysUserDTO = userDetails.getUser();
            if (sysUserDTO == null) {
                return null;
            }
            return sysUserDTO;
        }
        catch (Exception e) {
            log.error("sysUserCurrent error:", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<SysAreaRespDTO> findAreaByParam(List<String> areaCodes) {
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df-\u83b7\u53d6\u533a\u57df\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), areaCodes);
        try {
            HashSet<String> set = new HashSet<String>(areaCodes);
            SysAreaQueryDTO sysAreaQueryDTO = new SysAreaQueryDTO();
            sysAreaQueryDTO.setAreaCodes(set);
            ApiResult apiResult = this.sysAreaRpcService.queryList(sysAreaQueryDTO);
            return (List)apiResult.getData();
        }
        catch (Exception e) {
            log.error("findAreaByCodes error:", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public SysSettingVO findSysSetting(String settingNo) {
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df-\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)settingNo);
        try {
            SysSettingVO sysSettingVO = this.sysSettingService.oneByNo(settingNo);
            return sysSettingVO;
        }
        catch (Exception e) {
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df-\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\u670d\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Map<String, SysOrgBasicDTO> getParentByCodeAndParentType(Set<String> codes, String parentType) {
        if (CollectionUtil.isEmpty(codes)) {
            return new HashMap<String, SysOrgBasicDTO>();
        }
        try {
            ApiResult apiResult = this.orgRpcService.getParentByCode(codes, parentType);
            if (apiResult.isSuccess()) {
                Map orgBasicDTOMap = (Map)apiResult.getData();
                return orgBasicDTOMap;
            }
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7cfb\u7edf\u57df(getParentByCode)\u6839\u636e\u7f16\u7801\u83b7\u53d6\u4e0a\u7ea7\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a" + apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("getParentByCodeAndParentType error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7cfb\u7edf\u4e2d\u5fc3dubbo\u670d\u52a1\u5f02\u5e38\uff1a" + e);
        }
    }

    public SystemServiceImpl(SeqNumProvider sysNumberRuleService, SysUserFlowRoleRpcService sysUserFlowRoleRpcService, UdcProvider udcProvider, SysAreaRpcService sysAreaRpcService, ItmItemRpcService itemRpcService, SysUserRpcService sysUserService, SysSettingService sysSettingService, OrgRpcService orgRpcService) {
        this.sysNumberRuleService = sysNumberRuleService;
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.udcProvider = udcProvider;
        this.sysAreaRpcService = sysAreaRpcService;
        this.itemRpcService = itemRpcService;
        this.sysUserService = sysUserService;
        this.sysSettingService = sysSettingService;
        this.orgRpcService = orgRpcService;
    }
}

